/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc;

import com.goldendb.jdbc.CommunicationsException;
import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.internal.custom.LoadBalanceExceptionChecker;
import com.goldendb.jdbc.internal.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class StandardLoadBalanceExceptionChecker
implements LoadBalanceExceptionChecker {
    private List<String> sqlStateList;
    private List<Class<?>> sqlExClassList;

    public boolean shouldExceptionTriggerFailover(SQLException ex) {
        String sqlState = ex.getSQLState();
        if (sqlState != null) {
            if (sqlState.startsWith("08")) {
                return true;
            }
            if (this.sqlStateList != null) {
                Iterator<String> i = this.sqlStateList.iterator();
                while (i.hasNext()) {
                    if (!sqlState.startsWith(i.next().toString())) continue;
                    return true;
                }
            }
        }
        if (ex instanceof CommunicationsException) {
            return true;
        }
        if (this.sqlExClassList != null) {
            Iterator<Class<?>> i1 = this.sqlExClassList.iterator();
            while (i1.hasNext()) {
                if (!i1.next().isInstance(ex)) continue;
                return true;
            }
        }
        return false;
    }

    public void destroy() {
    }

    public void init(Connection conn, Properties props) throws SQLException {
        this.configureSQLStateList(props.getProperty("loadBalanceSQLStateFailover", null));
        this.configureSQLExceptionSubclassList(props.getProperty("loadBalanceSQLExceptionSubclassFailover", null));
    }

    private void configureSQLStateList(String sqlStates) {
        if (sqlStates != null && !"".equals(sqlStates)) {
            List<String> states = StringUtils.split(sqlStates, ",", true);
            ArrayList<String> newStates = new ArrayList<String>();
            for (String state : states) {
                if (state.length() <= 0) continue;
                newStates.add(state);
            }
            if (newStates.size() > 0) {
                this.sqlStateList = newStates;
            }
        }
    }

    private void configureSQLExceptionSubclassList(String sqlExClasses) {
        if (sqlExClasses != null && !"".equals(sqlExClasses)) {
            List<String> classes = StringUtils.split(sqlExClasses, ",", true);
            ArrayList newClasses = new ArrayList();
            for (String exClass : classes) {
                try {
                    Class<?> c = Class.forName(exClass);
                    newClasses.add(c);
                }
                catch (Exception var7) {}
            }
            if (newClasses.size() > 0) {
                this.sqlExClassList = newClasses;
            }
        }
    }
}

