/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc;

import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.MySQLConnection;
import com.goldendb.jdbc.Util;
import com.goldendb.jdbc.internal.log.GoldendbLog;
import com.goldendb.jdbc.profiler.ProfilerEventHandler;
import java.sql.SQLException;

public class ProfilerEventHandlerFactory {
    private Connection ownerConnection = null;
    protected GoldendbLog log = null;

    public static synchronized ProfilerEventHandler getInstance(MySQLConnection conn) throws SQLException {
        ProfilerEventHandler handler = conn.getProfilerEventHandlerInstance();
        if (handler == null) {
            handler = (ProfilerEventHandler)Util.getInstance(conn.getProfilerEventHandler(), new Class[0], new Object[0], conn.getExceptionInterceptor());
            conn.initializeExtension(handler);
            conn.setProfilerEventHandlerInstance(handler);
        }
        return handler;
    }

    public static synchronized void removeInstance(MySQLConnection conn) {
        ProfilerEventHandler handler = conn.getProfilerEventHandlerInstance();
        if (handler != null) {
            handler.destroy();
        }
    }

    private ProfilerEventHandlerFactory(Connection conn) {
        this.ownerConnection = conn;
        try {
            this.log = this.ownerConnection.getLog();
        }
        catch (SQLException var3) {
            throw new RuntimeException("Unable to get logger from connection");
        }
    }
}

