/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.jdbc.clientlogic;

import com.huawei.opengauss.jdbc.core.Field;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.ClientLogic;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.GroupByAggregator;
import java.math.BigDecimal;

public class GroupBySumAggregator
extends GroupByAggregator {
    private BigDecimal mSum;

    public GroupBySumAggregator(ClientLogic clientLogic) {
        super(clientLogic);
        this.reset();
    }

    @Override
    public final void reset() {
        this.mSum = new BigDecimal("0");
        this.setDataInserted(false);
    }

    @Override
    public void add(Field field, Object value) {
        if (value == null) {
            return;
        }
        switch (field.getSQLType()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                this.mDisplayType = GroupByAggregator.DisplayType.INT;
                this.mSum = this.mSum.add(new BigDecimal(value.toString()));
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                this.mDisplayType = GroupByAggregator.DisplayType.FLOAT;
                this.mSum = this.mSum.add(new BigDecimal(value.toString()));
                break;
            }
            default: {
                this.mDisplayType = GroupByAggregator.DisplayType.STRING;
                this.mSum = new BigDecimal("0");
            }
        }
        this.setDataInserted(true);
    }

    @Override
    public byte[] getResult() {
        if (!this.isDataInserted()) {
            return null;
        }
        return this.displayNumeric(this.mSum);
    }
}

