/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.jdbc.clientlogic;

import com.huawei.opengauss.jdbc.core.Field;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.ClientLogic;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.GroupByAggregator;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;

public class GroupByMinMaxAggregator
extends GroupByAggregator {
    protected boolean mFlagMax = false;
    protected BigDecimal mVal;
    protected String mValString;

    public GroupByMinMaxAggregator(ClientLogic clientLogic) {
        super(clientLogic);
        this.reset();
    }

    @Override
    public final void reset() {
        this.mVal = null;
        this.mValString = null;
        this.setDataInserted(false);
    }

    @Override
    public void add(Field field, Object value) {
        if (value == null) {
            return;
        }
        switch (field.getSQLType()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                this.mDisplayType = GroupByAggregator.DisplayType.INT;
                this.addNumber(value);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                this.mDisplayType = GroupByAggregator.DisplayType.FLOAT;
                this.addNumber(value);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.mDisplayType = GroupByAggregator.DisplayType.STRING;
                this.addString(value);
                break;
            }
        }
        this.setDataInserted(true);
    }

    private void addNumber(Object value) {
        if (this.mVal == null) {
            this.mVal = new BigDecimal(value.toString());
        } else {
            BigDecimal current = new BigDecimal(value.toString());
            if (this.mFlagMax) {
                if (this.mVal.compareTo(current) > 0) {
                    this.mVal = current;
                }
            } else if (this.mVal.compareTo(current) < 0) {
                this.mVal = current;
            }
        }
    }

    private void addString(Object value) {
        if (this.mValString == null) {
            this.mValString = value.toString();
        } else {
            String current = value.toString();
            if (this.mFlagMax) {
                if (this.mValString.compareTo(current) > 0) {
                    this.mValString = current;
                }
            } else if (this.mValString.compareTo(current) < 0) {
                this.mValString = current;
            }
        }
    }

    @Override
    public byte[] getResult() {
        if (this.mValString != null) {
            return this.mValString.getBytes(StandardCharsets.UTF_8);
        }
        if (this.mVal != null) {
            return this.displayNumeric(this.mVal);
        }
        return null;
    }
}

