/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.jdbc.clientlogic;

import com.huawei.opengauss.jdbc.core.Field;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.ClientLogic;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.GroupByAggregator;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;

public class GroupByAvgAggregator
extends GroupByAggregator {
    private BigDecimal mSum;
    private BigDecimal mCount;

    public GroupByAvgAggregator(ClientLogic clientLogic) {
        super(clientLogic);
        this.reset();
    }

    @Override
    public final void reset() {
        this.mSum = new BigDecimal("0");
        this.mCount = new BigDecimal("0");
        this.setDataInserted(false);
    }

    @Override
    public void add(Field field, Object value) {
        if (value == null) {
            return;
        }
        switch (field.getSQLType()) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.mSum = this.mSum.add(new BigDecimal(value.toString()));
                break;
            }
            default: {
                this.mSum = new BigDecimal("0");
            }
        }
        this.mCount = this.mCount.add(new BigDecimal("1"));
        this.setDataInserted(true);
    }

    @Override
    public byte[] getResult() {
        if (!this.isDataInserted()) {
            return null;
        }
        BigDecimal stripedSum = this.mSum.stripTrailingZeros();
        String str = this.mClientLogic.divide(stripedSum.toPlainString(), this.mCount.toPlainString());
        if (str != null) {
            return str.getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }
}

