/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.jdbc.clientlogic;

import com.huawei.opengauss.jdbc.core.Field;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.ClientLogic;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;

public abstract class GroupByAggregator {
    protected static final String ZERO_INT_STRING = "0";
    protected static final String ZERO_FLOAT_STRING = "0.000";
    protected int mColumnIndex = 0;
    protected boolean mDataInserted = false;
    protected ClientLogic mClientLogic;
    protected DisplayType mDisplayType = DisplayType.INT;

    public abstract void reset();

    public abstract void add(Field var1, Object var2);

    public abstract byte[] getResult();

    public GroupByAggregator(ClientLogic clientLogic) {
        this.mClientLogic = clientLogic;
    }

    public void setColumnIndex(int value) {
        this.mColumnIndex = value;
    }

    public int getColumnIndex() {
        return this.mColumnIndex;
    }

    public boolean isDataInserted() {
        return this.mDataInserted;
    }

    public void setDataInserted(boolean isValueInserted) {
        this.mDataInserted = isValueInserted;
    }

    public byte[] displayNumeric(BigDecimal value) {
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            if (this.mDisplayType == DisplayType.INT || this.mDisplayType == DisplayType.STRING) {
                return ZERO_INT_STRING.getBytes(StandardCharsets.UTF_8);
            }
            return ZERO_FLOAT_STRING.getBytes(StandardCharsets.UTF_8);
        }
        int scale = 3;
        if (this.mDisplayType == DisplayType.INT) {
            scale = 0;
        }
        String stripString = value.setScale(scale, 1).toPlainString();
        if (value.abs().compareTo(BigDecimal.ONE) < 0) {
            stripString = stripString.replace("0.", ".");
        }
        return stripString.getBytes(StandardCharsets.UTF_8);
    }

    protected static enum DisplayType {
        INT,
        FLOAT,
        STRING;

    }
}

