/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.clusterchooser;

import com.huawei.opengauss.jdbc.Driver;
import com.huawei.opengauss.jdbc.PGProperty;
import com.huawei.opengauss.jdbc.QueryCNListUtils;
import com.huawei.opengauss.jdbc.clusterchooser.ClusterStatus;
import com.huawei.opengauss.jdbc.hostchooser.DomainResolveInfo;
import com.huawei.opengauss.jdbc.hostchooser.DomainResolveTask;
import com.huawei.opengauss.jdbc.hostchooser.GlobalDomainResolveTracker;
import com.huawei.opengauss.jdbc.hostchooser.MultiHostChooser;
import com.huawei.opengauss.jdbc.log.Log;
import com.huawei.opengauss.jdbc.log.Logger;
import com.huawei.opengauss.jdbc.util.ClusterSpec;
import com.huawei.opengauss.jdbc.util.HostSpec;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalClusterStatusTracker {
    private static final Map<String, ClusterSpecStatus> clusterStatusMap = new HashMap<String, ClusterSpecStatus>();
    private static final Map<String, Boolean> firstConnectionMap = new ConcurrentHashMap<String, Boolean>();
    private static Map<String, String> masterClusterList = new HashMap<String, String>();
    private static Log LOGGER = Logger.getLogger(GlobalClusterStatusTracker.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportClusterStatus(ClusterSpec clusterSpec, ClusterStatus clusterStatus) {
        String key = GlobalClusterStatusTracker.keyFromClusterSpec(clusterSpec);
        Map<String, ClusterSpecStatus> map = clusterStatusMap;
        synchronized (map) {
            ClusterSpecStatus clusterSpecStatus = clusterStatusMap.get(key);
            if (clusterSpecStatus == null) {
                clusterSpecStatus = new ClusterSpecStatus(clusterSpec);
                clusterStatusMap.put(key, clusterSpecStatus);
            }
            clusterSpecStatus.status = clusterStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportMasterCluster(Properties props, ClusterSpec clusterSpec) {
        String urlKey = QueryCNListUtils.keyFromURL(props);
        String masterClusterKey = GlobalClusterStatusTracker.keyFromClusterSpec(clusterSpec);
        Map<String, String> map = masterClusterList;
        synchronized (map) {
            masterClusterList.put(urlKey, masterClusterKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterStatus getClusterStatus(HostSpec[] hostSpecs) {
        Object[] cloneHostSpecs = (HostSpec[])hostSpecs.clone();
        Arrays.sort(cloneHostSpecs);
        String clusterKey = Arrays.toString(cloneHostSpecs);
        Map<String, ClusterSpecStatus> map = clusterStatusMap;
        synchronized (map) {
            ClusterSpecStatus clusterSpecStatus = clusterStatusMap.get(clusterKey);
            if (clusterSpecStatus != null && clusterSpecStatus.status != null) {
                return clusterSpecStatus.status;
            }
        }
        return ClusterStatus.Unknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshProperties(Properties props) {
        boolean block;
        String key = QueryCNListUtils.keyFromURL(props);
        Map<String, Boolean> map = firstConnectionMap;
        synchronized (map) {
            block = firstConnectionMap.getOrDefault(key, false);
            firstConnectionMap.put(key, true);
        }
        String masterClusterkey = GlobalClusterStatusTracker.getMasterClusterkey(key, block);
        if ("".equals(masterClusterkey)) {
            return;
        }
        LOGGER.info("[PRIORITYSERVERS] Find the main cluster in dual clusters. | DualCluster: " + key + " | MasterCluster:" + masterClusterkey);
        PGProperty.MASTER_CLUSTER.set(props, masterClusterkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMasterClusterkey(String key, boolean block) {
        int intervalWaitHasRefreshedCNList = 10;
        int timesWaitHasRefreshedCNList = 200;
        for (int i = 0; i <= timesWaitHasRefreshedCNList; ++i) {
            Map<String, String> map = masterClusterList;
            synchronized (map) {
                String masterClusterKey = masterClusterList.get(key);
                if (masterClusterKey != null && !"".equals(masterClusterKey)) {
                    return masterClusterKey;
                }
            }
            if (!block) break;
            try {
                Thread.sleep(intervalWaitHasRefreshedCNList);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.info("[PRIORITYSERVERS] InterruptedException. This caused by: \"Thread.sleep\", waiting for refreshing master cluster from connection.");
            }
        }
        if (block) {
            LOGGER.info("[PRIORITYSERVERS] Blocking time extends 2 seconds need to pay attention.");
        }
        return "";
    }

    public static boolean isVaildPriorityServers(Properties props) {
        String priorityServers = PGProperty.PRIORITY_SERVERS.get(props);
        try {
            int priorityServersNumber = Integer.parseInt(priorityServers);
            int lengthPGPORTURL = props.getProperty("PGPORTURL").split(",").length;
            if (lengthPGPORTURL <= priorityServersNumber || priorityServersNumber <= 0) {
                LOGGER.warn("When configuring priority servers, The number of priority nodes should be less than the number of nodes on the URL and greater than 0.");
                return false;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("When configuring priority servers, \"priorityServers\" should be number.");
            return false;
        }
        return true;
    }

    public static Iterator<ClusterSpec> getClusterFromHostSpecs(HostSpec[] hostSpecs, Properties info) {
        ClusterSpec[] clusterSpecs;
        String priorityServers = PGProperty.PRIORITY_SERVERS.get(info);
        if (priorityServers != null) {
            clusterSpecs = new ClusterSpec[2];
            int index = Integer.parseInt(priorityServers);
            String masterCluster = PGProperty.MASTER_CLUSTER.get(info);
            if (MultiHostChooser.isUsingAutoLoadBalance(info) && masterCluster != null) {
                clusterSpecs[0] = new ClusterSpec(hostSpecs);
                HostSpec[] urlHostSpecs = Driver.getURLHostSpecs(info);
                HostSpec[] slaveHostSpecs = Arrays.copyOfRange(urlHostSpecs, index, urlHostSpecs.length);
                clusterSpecs[1] = !masterCluster.contains(slaveHostSpecs[0].toString()) ? new ClusterSpec(slaveHostSpecs) : new ClusterSpec(Arrays.copyOfRange(urlHostSpecs, 0, index));
            } else {
                HostSpec[] masterHostSpecs = Arrays.copyOfRange(hostSpecs, 0, index);
                HostSpec[] slaveHostSpecs = Arrays.copyOfRange(hostSpecs, index, hostSpecs.length);
                if (masterCluster != null && masterCluster.contains(slaveHostSpecs[0].toString())) {
                    clusterSpecs[0] = new ClusterSpec(slaveHostSpecs);
                    clusterSpecs[1] = new ClusterSpec(masterHostSpecs);
                } else {
                    clusterSpecs[0] = new ClusterSpec(masterHostSpecs);
                    clusterSpecs[1] = new ClusterSpec(slaveHostSpecs);
                }
            }
        } else {
            clusterSpecs = new ClusterSpec[]{new ClusterSpec(hostSpecs)};
        }
        return new ArrayList<ClusterSpec>(Arrays.asList(clusterSpecs)).iterator();
    }

    public static Iterator<ClusterSpec> getClusterFromUrlHostSpecs(Properties info) throws SQLException {
        ClusterSpec[] clusterSpecs;
        int priorityDomains = PGProperty.PRIORITY_DOMAINS.getInt(info);
        int primaryDomains = PGProperty.PRIMARY_DOMAINS.getInt(info);
        int refreshTime = PGProperty.REFRESH_DOMAIN_RESOLVE_TIME.getInt(info);
        HostSpec[] domainHostSpecs = GlobalClusterStatusTracker.domainHostSpecs(info);
        String masterCluster = PGProperty.MASTER_CLUSTER.get(info);
        if (primaryDomains > 0 && priorityDomains <= 0) {
            clusterSpecs = new ClusterSpec[2];
            HostSpec[] masterDomains = Arrays.copyOfRange(domainHostSpecs, 0, primaryDomains);
            HostSpec[] masterHosts = GlobalClusterStatusTracker.domainResolve(masterDomains, refreshTime);
            HostSpec[] slaveDomains = Arrays.copyOfRange(domainHostSpecs, primaryDomains, domainHostSpecs.length);
            HostSpec[] slaveHosts = GlobalClusterStatusTracker.domainResolve(slaveDomains, refreshTime);
            if (masterCluster != null && masterCluster.contains(slaveHosts[0].toString())) {
                clusterSpecs[0] = new ClusterSpec(slaveHosts, slaveDomains);
                clusterSpecs[1] = new ClusterSpec(masterHosts, masterDomains);
            } else {
                clusterSpecs[0] = new ClusterSpec(masterHosts, masterDomains);
                clusterSpecs[1] = new ClusterSpec(slaveHosts, slaveDomains);
            }
        } else if (primaryDomains > 0 && priorityDomains > 0) {
            clusterSpecs = new ClusterSpec[4];
            HostSpec[] priMasterDomains = Arrays.copyOfRange(domainHostSpecs, 0, priorityDomains);
            HostSpec[] priMasterHosts = GlobalClusterStatusTracker.domainResolve(priMasterDomains, refreshTime);
            HostSpec[] bakMasterDomains = Arrays.copyOfRange(domainHostSpecs, priorityDomains, primaryDomains);
            HostSpec[] bakMasterHosts = GlobalClusterStatusTracker.domainResolve(bakMasterDomains, refreshTime);
            HostSpec[] priSlaveDomains = Arrays.copyOfRange(domainHostSpecs, primaryDomains, primaryDomains + priorityDomains);
            HostSpec[] priSlaveHosts = GlobalClusterStatusTracker.domainResolve(priSlaveDomains, refreshTime);
            HostSpec[] bakSlaveDomains = Arrays.copyOfRange(domainHostSpecs, primaryDomains, domainHostSpecs.length);
            HostSpec[] bakSlaveHosts = GlobalClusterStatusTracker.domainResolve(bakSlaveDomains, refreshTime);
            if (masterCluster != null && (masterCluster.contains(priSlaveHosts[0].toString()) || masterCluster.contains(bakSlaveHosts[0].toString()))) {
                clusterSpecs[0] = new ClusterSpec(priSlaveHosts, priSlaveDomains);
                clusterSpecs[1] = new ClusterSpec(bakSlaveHosts, bakSlaveDomains);
                clusterSpecs[2] = new ClusterSpec(priMasterHosts, priMasterDomains);
                clusterSpecs[3] = new ClusterSpec(bakMasterHosts, bakMasterDomains);
            } else {
                clusterSpecs[0] = new ClusterSpec(priMasterHosts, priMasterDomains);
                clusterSpecs[1] = new ClusterSpec(bakMasterHosts, bakMasterDomains);
                clusterSpecs[2] = new ClusterSpec(priSlaveHosts, priSlaveDomains);
                clusterSpecs[3] = new ClusterSpec(bakSlaveHosts, bakSlaveDomains);
            }
        } else if (primaryDomains <= 0 && priorityDomains > 0) {
            clusterSpecs = new ClusterSpec[2];
            HostSpec[] priDomains = Arrays.copyOfRange(domainHostSpecs, 0, priorityDomains);
            HostSpec[] priHosts = GlobalClusterStatusTracker.domainResolve(priDomains, refreshTime);
            HostSpec[] bakDomains = Arrays.copyOfRange(domainHostSpecs, priorityDomains, domainHostSpecs.length);
            HostSpec[] bakHosts = GlobalClusterStatusTracker.domainResolve(bakDomains, refreshTime);
            clusterSpecs[0] = new ClusterSpec(priHosts, priDomains);
            clusterSpecs[1] = new ClusterSpec(bakHosts, bakDomains);
        } else {
            clusterSpecs = new ClusterSpec[1];
            HostSpec[] hostSpecs = GlobalClusterStatusTracker.domainResolve(domainHostSpecs, refreshTime);
            clusterSpecs[0] = new ClusterSpec(hostSpecs, domainHostSpecs);
        }
        DomainResolveTask.startTask();
        return new ArrayList<ClusterSpec>(Arrays.asList(clusterSpecs)).iterator();
    }

    private static HostSpec[] domainResolve(HostSpec[] domains, int refreshTime) throws SQLException {
        ArrayList<HostSpec> hostSpecs = new ArrayList<HostSpec>();
        for (HostSpec domain : domains) {
            try {
                DomainResolveInfo resolveInfo = GlobalDomainResolveTracker.refreshOrCreateResolveInfo(domain.getHost(), refreshTime);
                for (String ip : resolveInfo.getHostIps()) {
                    hostSpecs.add(new HostSpec(ip, domain.getPort(), resolveInfo.getDomainName()));
                }
            }
            catch (SQLException e) {
                LOGGER.warn("Resolve domain name for " + domain.getHost() + " failed.", e);
            }
        }
        return hostSpecs.toArray(new HostSpec[0]);
    }

    private static HostSpec[] domainHostSpecs(Properties props) {
        String[] ports = props.getProperty("PGPORTURL").split(",");
        String[] hosts = props.getProperty("PGHOSTURL").split(",", ports.length);
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    public static String keyFromClusterSpec(ClusterSpec clusterSpec) {
        Object[] hostSpecs = clusterSpec.getHostSpecs();
        Arrays.sort(hostSpecs);
        return Arrays.toString(hostSpecs);
    }

    static class ClusterSpecStatus {
        final ClusterSpec cluster;
        ClusterStatus status;

        ClusterSpecStatus(ClusterSpec cluster) {
            this.cluster = cluster;
        }

        public String toString() {
            return this.cluster.toString() + '=' + (Object)((Object)this.status);
        }
    }
}

