NOTE:
本文档用于指导业务人员通过jdbc访问GoldenDB数据库，内含参数修改全景、各版本新特性、场景使用推荐三个大章节。
=================

Total param change：
-----------------
| 变更类型   | 变更版本      |  参数名  | 参数说明                                                                                                  | 取值范围                    | 上一版本默认值                  | 默认值     | 
|:-------|:----------| :----  |:------------------------------------------------------------------------------------------------------|:------------------------|:-------------------------|:--------|
| add    | 5.1.46.54 | useConfigStmtRule | useConfigStmtRule=true时，对走prepare的语句，会根据数据库配置规则，判断强制走server prepare或者 client prepare                  | TRUE/FALSE              |                     | FALSE   |
| add    | 5.1.46.54 | checkConfigStmtRulePeriod | useConfigStmtRule=true，检查配置规则表的时间间隔，单位秒                                                               | 大于0整数                   |                     | 60      |
| modify | 5.1.46.53 | useBlackList | useBlackList=true时，不可用IP/PORT会加入黑名单； useBlackList=false时，不可用IP/PORT不加入黑名单                             | TRUE/FALSE              | FALSE                    | TRUE    |
| add    | 5.1.46.53 | loadBalanceTryTimes  | 驱动自研loadBalance建链时，对一个ip的尝试建链次数                                                                       | 大于0整数                   | 1                        |
| add    | 5.1.46.51 | customDatabaseProductName  | 驱动DatabaseMetaData调用getDatabaseProductName返回名称自定义                                                     | 自定义/MySQL               |                          | MySQL   |
| add    | 5.1.46.49 | useConnectionCollation  | useConnectionCollation=true，获取字段collation会使用连接中的collation                                             | TRUE/FALSE              |                          | false   |
| add    | 5.1.46.47 | forceSetCloseOnCompletionFalse  | forceSetCloseOnCompletionFalse=true，在设置statement的closeOnCompletion时，会强制变成false                        | TRUE/FALSE              |                          | false   |
| add    | 5.1.46.40 | batchExecuteWithErrorNumber  | batchExecuteWithErrorNumber=true,在事务中执行batchUpdate的时候（非prepare），当出现错误，异常信息携带错误sql的行数 (单独局点需求，不建议其他开启) | TRUE/FALSE              |                          | false   |
| modify | 5.1.46.38 | useBlackList | useBlackList=true时，不可用IP/PORT会加入黑名单； useBlackList=false时，不可用IP/PORT不加入黑名单                             | TRUE/FALSE              | TRUE                     | FALSE   
| add    | 5.1.46.37 | forceSyncSetNetworkTimeout | 驱动原生设置连接的networkTimeout默认传入一个线程池，设置参数可能同步可能异步，forceSyncSetNetworkTimeout参数为true，忽略线程池，强制同步            | TRUE/FALSE              |                          | false   
| add    | 5.1.46.36 | useBlackList | useBlackList=true时，不可用IP/PORT会加入黑名单；         useBlackList=false时，不可用IP/PORT不加入黑名单                     | TRUE/FALSE              | TRUE                     | TRUE    |
| modify | 5.1.46.31 | prepStmtCacheSize | 可以缓存预处理语句的个数,只在useCursorFetch或者useServerPrepStmts为true的情况下作用                                          | 大于0的整数                  | 2000                     | 500     |
| add    | 5.1.46.26 | masterConnection  | masterConnection=TRUE,开启主CN建链功能                                                                       | TRUE/FALSE              | FALSE                    |
| add    | 5.1.46.22 | multigroup  | dbgroup=g1指定分片，是否走多分片流程                                                                               | TRUE/FALSE              | FALSE                    |
| add    | 5.1.46.21 | batchUpdateDelete  | batchUpdateDelete=true，支持update、delete批量新协议                                                           | TRUE/FALSE              |                          | FALSE   |
| add    | 5.1.46.21 | readFromSlave  | readFromSlave=true，打开单分片备机查询功能                                                                        | TRUE/FALSE              |                          | FALSE   |
| add    | 5.1.46.2  | closeStmtOnCompletionAction  | 当参数com.goldendb.jdbc.StatementImpl#closeOnCompletion为true时，执行关闭Statement时候，是否关闭后端prepare              | TRUE/FALSE              |                          | FALSE   |
| modify | 5.1.46.2  | useCursorFetch | 是否启用游标和服务端prepare功能                                                                                   | TRUE/FALSE              | 源版本FALSE，5.1.46.1改成了TRUE | FALSE   | 
| modify | 5.1.46.2  | allowLoadLocalInfile | 是否启用LoadLocalInfile功能                                                                                 | TRUE/FALSE              | 源版本TRUE                  | FALSE   | 
| add    | 5.1.46.2  | convertClientPstmts  | 是否转化为客户端prepare                                                                                       | TRUE/FALSE              |                          | TRUE    |
| add    | 5.1.46.2  | reclaimBufferLength  | result buffer长度超过超过阈值，会被重新初始化                                                                         | 1024 * 50 ~ 1024 * 1024 |                          | 1048576 |
| add    | 5.1.46.2  | trackConnection    | 是否启用链路追踪                                                                                              | TRUE/FALSE              |                          | TRUE    |
| add    | 5.1.46.1  | prepareStrategy | 在服务端prepare开启的情况下，prepare的范围。1：只开启读语句的服务端prepare；2：读写均开启服务端prepare                                    | [1,2]                   |                          | 1       | 
| add    | 5.1.46.1  |  dumpListSize | 码流信息在每个connection连接上缓存的条数                                                                             | >=0                     |                          | 0       |
| add    | 5.1.46.1  |  dumpInfoLength | 每行码流信息保留的长度                                                                                           | >=0                     |                          | 1000    |
| add    | 5.1.46.1  | isConnectionLevel | 是否启自定义Loadbalance                                                                                     | TRUE/FALSE              |                          | TRUE    |
| add    | 5.1.46.1  | shadowThreadSwith | 是否开启连接自检测功能                                                                                           | TRUE/FALSE              |                          | TRUE    | 
| add    | 5.1.46.1  | intervalTime  | 每个影子链路发送"select 1"心跳的时间间隔，单位：ms                                                                       | 大于0的整数                  |                          | 2000    |
| add    | 5.1.46.1  | blackTaskTime | 黑名单的检测周期，单位：秒。每满一个周期会将黑名单中的条目尝试判白，白则出池激活，否则继续等下个周期                                                    | 大于0的整数                  |                          | 20      |
| add    | 5.1.46.1  | errorCount | 影子连接进行心跳时，判断为异常的失败次数。达到次数即判定为异常，进入黑名单                                                                 | 大于0的整数                  |                          | 1       |
| modify | 5.1.46.1  | cachePrepStmts | 是否开启缓存预处理语句的功能，                                                                                       | TRUE/FALSE              | FALSE                    | TRUE    |
| modify | 5.1.46.1  | prepStmtCacheSqlLimit | 预处理语句长度限制                                                                                             | 大于0的整数                  | 256                      | 2000    |
| modify | 5.1.46.1  | useSSL | 与服务器通信时使用SSL，连接到MySQL 5.5.45+，5.6.26+或5.7.6+时默认为"true"，否则为"false"                                     | TRUE/FALSE              | TRUE                     | FALSE   |
| modify | 5.1.46.1  | connectTimeout | socket连接超时（以毫秒为单位），0表示无超时。仅适用于JDK-1.4或更高版本。                                                           | >=0                     | 0                        | 10000   |
| modify | 5.1.46.1  | queryTimeoutKillsConnection | 当设置queryTimeout超时时间时，执行语句返回超时，是否将连接中断                                                                 | TRUE/FALSE              | FALSE                    | TRUE    |
| add    | 5.1.46.1  | dumpListSize | 异常码流信息条数                                                                                              | >=0                     |                          | 0       |
| add    | 5.1.46.1  | dumpInfoLength | 每条异常码流信息长度                                                                                            | >=0                     |                          | 1000    |
| add    | 5.1.46.1  | minconnectionproxys | loadbalance配置的组内有效的最小连接数                                                                              | >=0                     | 0                        |         | proxy所有版本 |
| add    | 5.1.46.1  | proxygroup(n) | loadbalance配置的组内地址                                                                                    | ip:port                 |                          | null    |
| add    | 5.1.46.1  | comStmtBatchFlag | 是否开启新协议批量插入功能                                                                                         | TRUE/FALSE              | FALSE                    |         | proxy 5.2.01 以及更新版本 |
| add    | 5.1.46.1  | dbgroup | 配置proxy下发分片                                                                                           | 有效分片g1,g2...gn          | null                     |         | proxy 6.1.01 以及更新版本 | 
| add    | 5.1.46.1  | longDataConvert | 强制将longdata类型转换为bytes                                                                                 | TRUE/FALSE              | TRUE                     |         | proxy所有版本 |

版本特性：

Edition：【5.1.46.57】 , Archieve date:2024/04/19  
切换ZXCLOUD-GoldenDB-Java-ConnectorV2.1P3



Edition：【5.1.46.56】 , Archieve date:2024/04/08  
1.删除META-INF中，services目录中，java.sql.Driver中com.goldendb.fabric.jdbc.FabricMySQLDriver，由于该类不存在，SPI加载会异常而停止继续加载其他驱动  
备注： shardingjdbc5.2.0中会加载多种驱动（其他类型数据库），由于gdb驱动中存在不存在的类FabricMySQLDriver，导致SPI加载异常而提前终止，最终导致异常  


Edition：【5.1.46.55】 , Archieve date:2024/03/28   
1.修复prepare情况下，getTime获取精度问题；  


Edition：【5.1.46.54】 , Archieve date:2024/03/22   
1.增加参数，控制prepare流程，当开启该规则时候，会有异步线程定时检测数据库配置规则并且刷新到缓存；  
2.当用户创建prepare，会根据缓存规则命中情况，然后根据规则配置，决定走server prepare 还是 client prepare  

注意：
- 用户首次获取连接时候，缓存jdbc url进行后续检测任务建链url，如果用户配置多数据源等等多个jdbc url，只有第一个生效
- 要求jdbc url中任意配置的CN上，都要可以查询到规则配置表gdb_stmt_handle_rule，并且内容一致
- 如果查询规则表异常，不会重试，默认等待下一周期继续查询
- 如果同样的sql，配置多条不同规则，不保证生效顺序
- 表结构如下：
``` SQL
  CREATE TABLE "gdb_stmt_handle_rule" (
  "id" int NOT NULL,
  "target_sql" varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  "matching_rule" int DEFAULT '1' COMMENT '1:开头匹配，用户输入的SQL以表中SQL为开头，表示匹配;',
  "handling_rule" int DEFAULT '0' COMMENT '0：强制非server prepare；1： 强制走server prepare',
  PRIMARY KEY ("id")
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin 
 ```

|  参数名  | 参数说明                                                         | 取值范围       | 上一版本默认值| 默认值   |
| :----  |:-------------------------------------------------------------|:-----------|  :----  |:------|
| useConfigStmtRule | useConfigStmtRule=true时，对走prepare的语句，会根据数据库配置规则，判断强制走server prepare或者 client prepare  | TRUE/FALSE |  | FALSE |
| checkConfigStmtRulePeriod | useConfigStmtRule=true，检查配置规则表的时间间隔，单位秒    | 大于0整数      |  | 60    |
<br>


Edition：【5.1.46.53】 , Archieve date:2024/03/20   
1.驱动在走自研loadBalance时候，对于选中的ip的尝试建链次数，默认1次  
注意：重试是单线程，重试过程对外就是建链卡主现象，如果外部有超时，可能导致超时，慎重使用该参数  
2.变更useBlackList默认值，从false --> true ； 现在可以控制分组、主CN、基础loadBalance是否开启黑名单

|  参数名  | 参数说明                                                         | 取值范围  | 上一版本默认值| 默认值 |
| :----  |:-------------------------------------------------------------|:------|  :----  |:----|
| loadBalanceTryTimes | 驱动自研loadBalance建链时（isConnectionLevel=true,默认符合），对一个ip的尝试建链次数 | 大于0整数 |  | 1   |



Edition：【5.1.46.52】 , Archieve date:2024/03/19   
兼容性问题，解决getTime时候，无法获取到毫米问题
数据库使用time(3)类型10:27:58.123 ，java使用getTime获取java.sql.Time时候，内部类cdate无法获取小数后的精度(直接输出getTime无区别，需要转成date)
兼容性问题，解决LocalTime毫秒丢失问题
数据库使用time(3)类型10:27:58.123 ，java使用getObject映射成为LocalTime
修改数据库使用time(3)类型10:27:58.123，java使用getTimestamp获取没有毫秒值问题



Edition：【5.1.46.51】 , Archieve date:2024/03/12
1.驱动DatabaseMetaData调用getDatabaseProductName返回名称自定义，使用方式直接配置在url中 customDatabaseProductName="abc"  

|  参数名  | 参数说明 | 取值范围 | 上一版本默认值|默认值 |
| :----  | :----  | :----  |  :----  | :----  |
| customDatabaseProductName |驱动DatabaseMetaData调用getDatabaseProductName返回名称自定义   | 自定义 |  | MySQL |

注意：由于ak版本问题，所以跳过50这个版本，直接变成51

Edition：【5.1.46.49】 , Archieve date:2024/02/26

|  参数名 | 参数说明                                                               | 取值范围 | 默认值 |  
| :----  |:-------------------------------------------------------------------| :----  |  :----  |  
| useConnectionCollation  | useConnectionCollation=true时，获取字段collation会使用连接中的collation | TRUE/FALSE |FALSE|
部分场景中，由于proxy、dn返回字段中originalTableName为别名存在bug，字段获取collation时，执行SHOW FULL COLUMNS FROM table，拼接别名，导致表不存在异常，增加该参数，参考8.x版本，改变获取collation逻辑，启用该参数，直接使用Connection中的collation


Edition：【5.1.46.48】 , Archieve date:2024/02/20   
增加loadBalance过程中，每个ip建链失败日志；
重要： 5.1.46.36 已经修改useBlackList默认值false,但是对于分组的情况（分组或者主CN）该参数永远默认true
黑名单解释： 在loadBalance的时候，如果ip建链异常，进入监控名单（临时黑名单，执行检查间隔更小，防止网络瞬断引起建链异常），监控黑名单校验ip仍旧失败，进入黑名单，下次loadBalance时，会忽略在黑名单中的ip  

Edition：【5.1.46.47】 , Archieve date:2024/02/19  

|  参数名 | 参数说明 | 取值范围 | 默认值 |  
| :----  | :----  | :----  |  :----  |  
| forceSetCloseOnCompletionFalse  | forceSetCloseOnCompletionFalse=true时，在设置statement的closeOnCompletion时，会强制变成false    | TRUE/FALSE |FALSE|
forceSetCloseOnCompletionFalse=true时，在调用com.goldendb.jdbc.StatementImpl#closeOnCompletioncloseOnCompletion方法时，会将参数closeOnCompletion设置成为false, 强制变成false;
forceSetCloseOnCompletionFalse=false时，在调用com.goldendb.jdbc.StatementImpl#closeOnCompletioncloseOnCompletion方法时，会将参数closeOnCompletion默认设置成为true;
解决高版本mybatis 使用server prepare，在close的时候，会默认设置closeOnCompletion=true会导致客户端缓存的server prepare被清除，但是没有向服务端发送关闭prepare请求，导致CN prepare积压


Edition：【5.1.46.42】 , Archieve date:2023/12/28  
增加OffsetDateTime支持，ResultSet.getObject(1, OffsetDateTime.class),可以正常返回(mybatis映射使用该方式)  


Edition：【5.1.46.40】 , Archieve date:2023/12/14  
增加参数 batchExecuteWithErrorNumber，默认值false，batchExecuteWithErrorNumber=true,在事务中执行batchUpdate的时候（非prepare），当出现错误，异常信息携带错误sql的行数 (单独局点需求，不建议其他开启) ;
使用该功能，需要url里配置allowMultiQueries=true

Edition：【5.1.46.39】 , Archieve date:2023/12/13  
1.增加com.goldendb.jdbc.vendor.GoldendbExceptionSorter

Edition：【5.1.46.38】 , Archieve date:2023/12/04  
1.默认不启用黑名单功能
2.组优先级loadbalance，依赖于黑名单功能，所以当参数proxygroups>0时，设置useBlackList=true  

|  参数名  | 参数说明 | 取值范围 | 默认值 | 
| :----  | :----  | :----  |  :----  | 
| useBlackList  | useBlackList=true时，不可用IP/PORT会加入黑名单 | TRUE/FALSE |FALSE|


Edition：【5.1.46.37】 , Archieve date:2023/11/30  
1.驱动原生设置连接的networkTimeout默认传入一个线程池，线程池可能是同步的，也可能是异步的，当异步线程池时候，设置networkTimeout存在并发问题导致连接执行前无法正确设置该参数；  
目前Hikari 4.0.3版本发现出现bug，使用jdbc:goldendb协议url，会走两次setNetworkTimeout,一次设置为validTimeout，一次为正常值，异步设置导致无法保证顺序；  
由于该接口是java.sql标志，为了兼容原有逻辑，新增forceSyncSetNetworkTimeout参数，当为true，忽略传入线程池，强制同步执行。    
注意：默认值为false，代表不启用，当出现问题时，考虑启用该参数

Edition：【5.1.46.36】 , Archieve date:2023/11/24  
1.增加黑名单功能开关，useBlackList=true时，不可用IP/PORT会加入黑名单；
  useBlackList=false时，不可用IP/PORT不加入黑名单。

Edition：【5.1.46.35】 , Archieve date:2023/11/14  
1.noDatetimeStringSync=true时，getString获取time数据类型，支持精度输出

Edition：【5.1.46.31】 , Archieve date:2023/10/08   
1.prepStmtCacheSize 默认值修改，从2000变更为500  
2.涉及CN内存预留，计算规则如下：
目前一个serverPrepare大概占用300KB内存；
假设总共有A个高可用项目，每个项目中配置B个数据库连接；一共有P个CN可用
假设缓存数据设置为N，有公式：
``` A*B/P*N*300KB = CN prepare占用内存 ```  
原则：每个CN保持的开启服务端PrepareCache的连接数数量 * 300K = CN prepare占用内存

Edition：【5.1.46.30】 , Archieve date:2023/10/01  
1)masterconnection功能支持url配域名，url中域名与IP是一对一的关系，
  不支持一个域名对应多个IP的配置
2)业务端与CN之间不能有F5之类的负载均衡

Edition：【5.1.46.29】 , Archieve date:2023/09/13  
1.新增com.mysql.jdbc.Driver
-----------------
    驱动支持Class.forName("com.goldendb.jdbc.Driver")、Class.forName("com.mysql.jdbc.Driver")两种方式加载


Edition：【5.1.46.26】 , Archieve date:2023/05/30
1.主CN建链功能
在组优先级的基础上，建链前，先查找主CN，再进行建链
此功能有如下限制：
    1)goldendb环境中主DN的IP即为主CN的IP
    2)相同的IP不能配置到不同的组

|  参数名  | 参数说明 | 取值范围 | 默认值 | 
| :----  | :----  | :----  |  :----  | 
| masterConnection  | masterConnection=TRUE,开启主CN建链功能 | TRUE/FALSE |FALSE|

Edition：【5.1.46.25】 , Archieve date:2023/05/24
1.URL可以配置为jdbc:mysql或者jdbc:goldendb

Edition：【5.1.46.23】 , Archieve date:2023/04/01
1.MysqlXADataSource改为GoldendbXADataSource

Edition：【5.1.46.22】 , Archieve date:2023/03/08
1.多分片指定group功能
-----------------
dbgroup=g1指定分片，当multigroup=true，CN走多分片处理流程，
当multigroup=false，dbgroup=g1指定分片，CN走单分片透传处理流程
需要proxy 6.1.02 以及更新版本

|  参数名  | 参数说明 | 取值范围 | 默认值 | 
| :----  | :----  | :----  |  :----  | 
| multigroup  | dbgroup=g1指定分片，是否走多分片流程 | TRUE/FALSE |FALSE|

Edition：【5.1.46.21】 , Archieve date:2023/02/20
1.支持update、delete批量新协议
-----------------
    1.当comStmtBatchFlag=true，批量新协议开关打开时，batchUpdateDelete=true，
      支持insert、update、delete批量新协议，batchUpdateDelete=false,只支持insert批量新协议
    2.需要proxy 6.1.02 以及更新版本
|  参数名  | 参数说明 | 取值范围 | 默认值 | 
| :----  | :----  | :----  |  :----  | 
| batchUpdateDelete  | batchUpdateDelete=true，支持update、delete批量新协议 | TRUE/FALSE |FALSE|

2.单分片备机只读查询
-----------------
    1.readFromSlave=true，设置链路属性只读，服务端选择一个备机下发所有sql，只对proxy单分片模式有效
    2.需要proxy 6.1.02 以及更新版本
|  参数名  | 参数说明 | 取值范围 | 默认值 | 
| :----  | :----  | :----  |  :----  | 
| readFromSlave  | readFromSlave=true，打开单分片备机只读查询功能 | TRUE/FALSE |FALSE|

Edition：【5.1.46.2】 , Archieve date:2022/07/21
=================
1.默认参数修改
-----------------
|  参数名  | 参数说明 | 取值范围 | 上一版本默认值|默认值 | 
| :----  | :----  | :----  |  :----  | :----  |
| useCursorFetch | 是否启用游标和服务端prepare功能 | TRUE/FALSE | TRUE | FALSE | 


2.某些场景下游标失效
-----------------
     计算节点侧Prepare报错，驱动会将prepare转为普通语句，导致游标失效，数据库返回所有结果（数据量较大）给应用，导致应用OOM。
     优化方法：增加参数，convertClientPstmts=FALSE时，若prepare报错后，驱动直接抛出异常信息。

|  参数名  | 参数说明 | 取值范围 | 默认值 | 
| :----  | :----  | :----  |  :----  | 
| convertClientPstmts  | 是否转化为客户端prepare | TRUE/FALSE | TRUE|


3.优化读buffer内存占用
-----------------
    驱动里读取数据的buffer初始化50K，在读取中逐渐增大，比如数据读取完后该buffer增大到900K，驱动会判断buffer超过1M后才进行重新初始化为50K，导致驱动占用应用服务器内存过大。
    优化方法：增加参数，可以设置buffer初始化的阈值。

|  参数名  | 参数说明 | 取值范围 | 默认值 | 
| :----  | :----  | :----  |  :----  | 
| reclaimBufferLength | result buffer长度超过超过阈值，会被重新初始化 | 1024 * 50 ~ 1024 * 1024 | 1048576 |


4.优化连接回收机制
-----------------
    JDBC链路垃圾回收机制是将已关闭的连接放到一个队列里去，然后由专门的线程负责释放链路对象，这导致链路对象虽然被关闭，但可能还存在内存中; 但这种处理机制有一个好处，
    能够保证链路不论是否正常关闭，都不会出现资源泄露。
    优化方法：trackConnection=FALSE时，则不会将已关闭链路加入链路释放队列中。
    
|  参数名  | 参数说明 | 取值范围 | 默认值 | 
| :----  | :----  | :----  |  :----  | 
| trackConnection    | 是否启用链路追踪 | TRUE/FALSE | TRUE|


5.栈信息打印IP+PORT
-----------------
    1)当出现链路异常后，在抛出的jdbc4.CommunicationsException中，增加链路信息打印：
        com.goldendb.jdbc.internal.exceptions.jdbc4.CommunicationsException: LinkInfo:[client]=28.5.4.80:50710 ==> [target]=28.4.199.180:5160
        Communications link failure
    2)当主动调用ConnectionImpl类的commit()方法出现异常时，在抛出的exception中增加链路信息打印：
        com.goldendb.jdbc.internal.exceptions.jdbc4.MySQLNonTransientConnectionException: LinkInfo:[client]=28.5.4.80:50429 ==> [target]=28.4.199.180:5160
        Communications link failure during commit(). Transaction resolution unknown. 
    3)当主动调用ConnectionImpl类的rollback()方法出现异常时，在抛出的exception中增加链路信息打印：
        com.goldendb.jdbc.internal.exceptions.jdbc4.MySQLNonTransientConnectionException: LinkInfo:[client]=28.5.4.80:50746 ==> [target]=28.4.199.180:5160
        Communications link failure during rollback(). Transaction resolution unknown. 

6.CVE-2021-2471漏洞修复
-----------------
    漏洞描述链接 https://pyn3rd.github.io/2021/10/22/mysql-jdbc-xxe/

7.自定义lodbalance报错提示优化
-----------------
    自定义lodbalance与原生lodbalance异常处理保持一致，将最后一次异常建链信息打印在栈信息。

8.CVE-2020-2875漏洞修复
-----------------
    allowLoadLocalInfile默认改为false

9.打印建链相关日志
-----------------
    1.建立socket链路
    2.mysql握手交互
    3.获取服务器相关配置
    4.设置字符集

10.原生loadbalance修改
-----------------
    修复库名为空，原生loadbalance无法继续使用。

11.高版本mybatis无法关闭prepare
-----------------
    原生JDBC的closeOnCompletion流程，不会关闭后端prepare
    优化方法：closeStmtOnCompletionAction=true时，流程结束时，关闭后端prepare
    
|  参数名  | 参数说明 | 取值范围 | 默认值 | 
| :----  | :----  | :----  |  :----  | 
| closeStmtOnCompletionAction  | 当参数com.goldendb.jdbc.StatementImpl#closeOnCompletion为true时，执行关闭Statement时候，是否关闭后端prepare | TRUE/FALSE |  | FALSE|

Edition：【5.1.46.1】 , Archieve date:2022/07/08
=================
1.JDBC获取proxy建链消息中的proxy实际IP+port，并在duplicate新链路发送kill query 命令查杀超时请求
-----------------
    说明： 解决配套分布式数据库引入缺陷。
    JDBC通过F5等、LVS等负载均衡接入GoldenDB，在客户端尝试主动断开JDBC链接过程中，会通过另外的连接通道发送KILL QUERY请求给服务器，该请求经过F5等负载均衡设备时会被分发至其他计算节点(proxy),导致原计算节点链接没有释放，而其他计算节点上的正常链接被释放了。
    解决方法：JDBC在建链中获得计算节点实际IP+Port，发送KILL QUERY请求时直接连接该计算节点的IP+Port而不再经过负载均衡设备。


2.JDBC通过参数配置支持服务端prepare对读写的支持
-----------------
    说明：这里有个深奥的概念：客户端prepare VS 服务端prepare。MySQL协议跟Oracle不同，先有jdbc标准中的prepare接口，后再有MySQL实现服务端prepare接口。这样带来的好处是：业务可以遵循标准的prepare接口进行编码，但实际通过客户端的组合将语句组装成普通语句下发给服务端DB，这样的内部实现称为客户端prepare。而服务端prepare，则是客户端使用的是prepare协议实际跟DB进行交互。
    实际使用中，MySQL的服务端prepare只有正确使用结合缓存使用才有作用，否则性能下降严重而服务端消耗反而增加。
    添加JDBC参数prepareStrategy：取值范围[1,2]，默认值1，只在useCursorFetch或者useServerPrepStmts为true的情况下作用。1：只开启读语句的服务端prepare；2：读写均开启服务端prepare

|  参数名  | 参数说明 | 取值范围 | 上一版本默认值|默认值 | 
| :----  | :----  | :----  |  :----  |   :----  | 
| prepareStrategy |在服务端prepare开启的情况下，prepare的范围。1：只开启读语句的服务端prepare；2：读写均开启服务端prepare| [1,2] | | 1 | 


3.去除写语句执行前的readonly判断，悲观模式改成乐观模式
-----------------
    说明：去除业务请求过程中在写语句执行前无价值的写语句readonly判断，悲观模式改成乐观模式


4.JDBC记录与proxy的通信码流栈，异常时输出最近的n条码流栈信息，打印源端与本端真实的IP port，用于配合抓包分析通讯故障
-----------------
    说明：对通讯层的故障定位能力进行强化，当JDBC连接的socket层连接出现异常时，打印源和目标的IP端口，日志进行标准格式化。
|  参数名| 参数说明 | 取值范围 | 默认值 | 
| :----  | :----  | :----  |  :----  |
| dumpListSize | 码流信息在每个connection连接上缓存的条数 | >=0 | 0 |
| dumpInfoLength | 每行码流信息保留的长度| >=0 | 1000 |


5.LoadBanlance协议支持连接级负载均衡
-----------------
    说明:原有Loadbalance协议中的负载均衡是在每次触发commit和rollback时，进行拦截并对Connection对象重新初始化，这样就会对客户端使用PreparedStatement产生限制，要求在业务中的prepare对象不能是全局对象，因为在触发拦截后，Connection对象已被替换成新的，无法跟业务代码中全局prepare对象进行映射匹配。同时在原有的loadbalance协议下，一个客户端连接会同时创建n个物理连接到配置的ip列表端，这些连接用于loadbanlance切换用，导致实际到服务端的连接翻n倍，浪费宝贵的连接资源。
    解决方法: 修改后在连接初始化时，按URL配置信息选出一个可用的Proxy，同时将此协议变换为jdbc原有协议而不使用Loadbalance，每次重新初始化连接时还会根据URL配置的Proxy，按照随机策略进行负载均衡选取。
    使用说明: JDBC的URL中增加一个参数isConnectionLevel=true(默认为true，可以不在url不显示增加) 同时复用LoadBanlance协议,即可打开此功能。如果为false或者不填则走原来的LoadBanlance协议逻辑。
    PS:isConnectionLevel=true时，原loadbalance辅助的参数，如负载均衡策略等均失效。

|  参数名  | 参数说明 | 取值范围 | 默认值 | 
| :----  | :----  | :----  |  :----  |
| isConnectionLevel | 是否启自定义Loadbalance | TRUE/FALSE | TRUE|


6.JDBC增加连接自管理能力、增加黑名单管理能力
-----------------
    说明：增加"连接分组自管理及黑名单功能"，主要实现思路：在loadbalance+isConnectionLevle=true时，对每个proxy的IP+port建立管理组，同时增加一个影子连接，影子连接定期心跳，心跳异常则杀死全组的链接并加入黑名单，黑名单定时探测，链路正常后再踢出黑名单。

| 参数名                | 参数说明  | 取值范围 | 默认值  |
|:-------------------| :----  | :----  |  :----  |
| shadowThreadSwitch | 是否开启连接自检测功能 | TRUE/FALSE | TRUE | 
| intervalTime       | 每个影子链路发送"select 1"心跳的时间间隔，单位：ms | 大于0的整数 | 2000 |
| blackTaskTime      | 黑名单的检测周期，单位：秒。每满一个周期会将黑名单中的条目尝试判白，白则出池激活，否则继续等下个周期 | 大于0的整数 | 20 |
| errorCount         | 影子连接进行心跳时，判断为异常的失败次数。达到次数即判定为异常，进入黑名单 | 大于0的整数 | 1 |


7.jdbc常用参数默认值优化
-----------------
|  参数名| 参数说明 | 取值范围 | 默认值          | 
| :----  | :----  | :----  |:-------------|
| useCursorFetch | 是否启用游标功能 | TRUE/FALSE | TRUE         | 
| cachePrepStmts | 是否开启缓存预处理语句的功能,只在useCursorFetch或者useServerPrepStmts为true的情况下作用 | TRUE/FALSE | TRUE         |
| prepStmtCacheSize | 可以缓存预处理语句的个数 | 大于0的整数 | 2000 --> 500 |
| prepStmtCacheSqlLimit | 预处理语句长度限制 | 大于0的整数 | 2000         |
| useSSL | 与服务器通信时使用SSL，连接到MySQL 5.5.45+，5.6.26+或5.7.6+时默认为"true"，否则为"false" | TRUE/FALSE | FALSE        |
| connectTimeout | socket连接超时（以毫秒为单位），0表示无超时。仅适用于JDK-1.4或更高版本。 默认值为0。| >=0 | 10000        |
| queryTimeoutKillsConnection | 当设置queryTimeout超时时间时，执行语句返回超时，是否将连接中断 | TRUE/FALSE | TRUE         |
| dumpListSize | 异常码流信息条数 | >=0 | 0            |
| dumpInfoLength | 每条异常码流信息长度| >=0 | 1000         |


8.JDBC loadbalance支持将计算节点按分组优先级
-----------------
    说明：支持驱动loadbalance配置多个组，在组间负载均衡。采用LB的优先级分组能力,各机房业务配置相同,优先访问主机房的计算节点,在出现机房级异常后依次访问低优先级的计算节点组。

    当链接proxy最小数为0时，则只访问当前最大优先级proxy，当最大优先级proxy都异常时，则连接下一优先级proxy。
| 参数名 | 参数说明                     | 取值范围 | 默认值 | proxy支持版本 |
| :----  |:-------------------------| :----  |  :----  | :----  |
| minconnectionproxys | loadbalance配置的组内有效的最小连接数 | >=0 | 0 | proxy所有版本 |
| proxygroup(n) | loadbalance配置的组内地址       | ip:port | null |


9.新增insert批量新协议
-----------------
    说明：支持insert批量新协议
    1.使用新协议批量插入insert数据，理论上比只使用rewriteBatchedStatements=true性能更好。
    2.可以提升批量插入语句性能。
    3.对update和delete无效
| 参数名 | 参数说明 | 取值范围 | 默认值 | proxy支持版本 |
| :----  | :----  | :----  |  :----  | :----  |
| comStmtBatchFlag | 是否开启新协议批量插入功能 | TRUE/FALSE | FALSE | proxy 5.2.01 以及更新版本 |


10.JDBC支持设置proxy下发group
-----------------
    说明：支持建链时，设置proxy的下发group
| 参数名 | 参数说明 | 取值范围 | 默认值 | proxy支持版本 |
| :----  | :----  | :----  |  :----  | :----  |
| dbgroup | 配置proxy下发分片 | 有效分片g1,g2...gn | null | proxy 6.1.01 以及更新版本 | 


11.JDBC驱动优化之支持版本识别
-----------------
    1)进去jar包所在目录
    2)执行java -classpath "./*"  com.goldendb.jdbc.DriverVersion

12.bug优化 修改时间20220323
-----------------
    1.修复黑名单异常建链BUG
    2.服务器变量，字段名统一转换为小写
    3.loadbalance默认走自定义流程
    4.优化自定义建链流程，不带参数也正常建链


13.功能 longdata数据类型转换  修改时间20220422
-----------------
| 参数名 | 参数说明 | 取值范围 | 默认值 | proxy支持版本 |
| :----  | :----  | :----  |  :----  | :----  |
| longDataConvert | 强制将longdata类型转换为bytes | TRUE/FALSE | TRUE | proxy所有版本 |




常用的JDBC url配置示例
=================
 JDBC URL基本格式：
-----------------
    jdbc:goldendb://DBProxyIP:ClusterPort/DBName?parameterName1=parameterValue1&parameterName2=parameterValue2 ...
    样例：jdbc:goldendb://192.168.100.7:7788/testdb?useCursorFetch=true&useSSL=false

    使用loadbalance负载均衡格式：
    jdbc:goldendb:loadbalance://DBProxyIP1:ClusterPort1,DBProxyIP2:ClusterPort2,.../DBName?parameterName1=parameterValue1&parameterName2=parameterValue2...
    样例：jdbc:goldendb:loadbalance://192.168.100.7:7788,192.168.100.8:7788/testdb?useCursorFetch=true&useSSL=false


1.loadbalance按分组优先级示例：
-----------------
    url="jdbc:goldendb:loadbalance://192.168.100.11:7788,192.168.100.12:7788/test?minconnectionproxys=1&proxygroups=2&proxygroup1=192.168.100.7:7788,192.168.100.8:7788&proxygroup2=192.168.100.9:7788,192.168.100.10:7788"
  
     minconnectionproxys--组内正常可用proxy个数
     proxygroups--分组个数，proxygroup1，proxygroup2......优先级依次降低
     当高优先级proxy正常数量未达到minconnectionproxys时，则部分请求下发到下一个优先级proxy节点，下一个优先级所有的proxy参与负载。
     当链接proxy最小数为0时，则只访问当前最大优先级proxy，当最大优先级proxy都异常时，则连接下一优先级proxy。
  
     URL说明：proxygroups=0, JDBC执行原始loadbalance流程，IP+PORT范围是192.168.100.11:7788,192.168.100.12:7788; JDBC执行组优先级loadbalance流程，proxygroups!=0,IP+PORT范围是proxygroup1、proxygroup2配置值
  

2.proxy下发指定group示例:
-----------------
    url="jdbc:goldendb://192.168.100.7:7788/testdb?dbgroup=g1"
3.insert批量协议示例:
-----------------
    url="jdbc:goldendb://192.168.100.7:7788/testdb?comStmtBatchFlag=true"
漏洞修复情况
=================
| 漏洞编号 | 等级 | 说明| 修复情况 | 
| :----  | :----  | :----  |  :----  |
|CVE-2021-3711 | 超危 | OpenSSL 缓冲区错误漏洞 | 已修复，修复方法JDBC移除TLS 1.0 and 1.1版本支持 |
|CVE-2018-3258 | 高危 | Oracle MySQL Connectors组件访问控制错误漏洞 | X 协议漏洞，5.1.46没有X协议功能，无此漏洞 |
|CVE-2020-1967 | 高危 | Openssl OpenSSL 代码问题漏洞 | 已修复，修复方法JDBC移除TLS 1.0 and 1.1版本支持 |
|CVE-2021-3712 | 高危 | OpenSSL 缓冲区错误漏洞 | 已修复，修复方法JDBC移除TLS 1.0 and 1.1版本支持 |
|CVE-2021-3450 | 高危 | OpenSSL 安全漏洞 | 已修复，修复方法JDBC移除TLS 1.0 and 1.1版本支持 |
|CVE-2020-2875 | 中危 | Oracle MySQL 安全漏洞 | CVE-2020-2875已修复，修复方法参考官方驱动 |
|CVE-2019-2692 | 中危 | Oracle MySQL Connectors 输入验证错误漏洞 |CVE-2019-2692已修复，修复方法参考官方驱动 |
|CVE-2020-2934 | 中危 | Oracle MySQL 安全漏洞 | CVE-2020-2934已修复，修复方法参考官方驱动 |
|CVE-2021-2471 | 中危 | Oracle MySQL 输入验证错误漏洞 | CVE-2021-2471已修复，修复方法参考官方驱动 |
|CVE-2019-10219 | 中危 | Hibernate Validator 跨站脚本漏洞 | Hibernate-Validator漏洞，与驱动无关。 |
|CVE-2021-3449 | 中危 | OpenSSL 拒绝服务漏洞 | 已修复，修复方法JDBC移除TLS 1.0 and 1.1版本支持 |
|CVE-2022-21363 | 中危 | Oracle MySQL 输入验证错误漏洞 | 该漏洞为开源软件8.1.15以前版本引入， 需要用户密码认证且需要高权用户。GDB不对外提供高权用户，对goldenDB并没有什么影响。如何修复。还在研究 |
|CVE-2020-2933 | 低危 | Oracle MySQL 安全漏洞 | CVE-2020-2933已修复，修复方法参考官方驱动 |
|BDSA-2019-3759 | 低危 | Oracle MySQL Connectors 安全漏洞 | BDSA-2019-3759漏洞已修复，解决方法：1.mysql服务端设置 /etc/my.cnf中设置local-infile=0 2.驱动allowLoadLocalInfile默认改为false |   

JDBC 日志输出到文件配置方法
=================
    1.添加log4j依赖包，log4j-*.jar,slf4j-api-*.jar,slf4j-log4j*.jar
    2.添加log4j.properties配置文件
        #example
        log4j.logger.jdbc.sqlonly=ON
        log4j.logger.jdbc.sqltiming=INFO
        log4j.logger.jdbc.audit=ON
        log4j.logger.jdbc.resultset=ON
        log4j.logger.jdbc.connection=ON
         
        log4j.logger.jdbc.sqlonly=console,RollingFile
        log4j.logger.jdbc.audit=console,RollingFile
        log4j.logger.jdbc.connection=console,RollingFile
        log4j.appender.console=org.apache.log4j.ConsoleAppender
        log4j.appender.console.layout=org.apache.log4j.PatternLayout
        log4j.appender.console.layout.ConversionPattern=%d{yyyy-MM-dd HH:mm:ss.SSS} %m%n%n
        
        #RollingFile
        log4j.appender.RollingFile = org.apache.log4j.RollingFileAppender
        log4j.appender.RollingFile.File = log_test.log
        log4j.appender.RollingFile.MaxFileSize=10MB
        log4j.appender.RollingFile.MaxBackupIndex=3
        log4j.appender.RollingFile.layout = org.apache.log4j.PatternLayout
        log4j.appender.RollingFile.layout.ConversionPattern =%d [%t] %-5p [%c] - %m%n
         
        log4j.rootLogger=DEBUG,console,RollingFile
    
    3.JDBC url加上参数logger=com.goldendb.jdbc.log.Slf4JLogger
