/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionParameters;
import com.hundsun.lightdb.event.SpringTaskExcuteEvent;
import com.hundsun.lightdb.motion.dao.TaskRecordEntityMapper;
import com.hundsun.lightdb.motion.entity.TaskLogEntity;
import com.hundsun.lightdb.motion.entity.TaskRecordEntity;
import com.hundsun.lightdb.motion.enums.DeleteStatusEnum;
import com.hundsun.lightdb.motion.service.TaskLogService;
import com.hundsun.lightdb.motion.service.TaskRecordService;
import com.hundsun.lightdb.motion.vo.request.TaskRecordQueryReqVo;
import com.hundsun.lightdb.motion.vo.response.TaskRecordRespVo;
import com.hundsun.lightdb.utils.BeanCopyUtil;
import com.hundsun.lightdb.utils.idworker.IdUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"etl.global.runModel"}, havingValue="1")
public class TaskRecordServiceImpl
implements TaskRecordService,
ApplicationListener<SpringTaskExcuteEvent> {
    @Autowired
    private TaskRecordEntityMapper taskRecordEntityMapper;
    @Autowired
    private TaskLogService taskLogService;

    public Integer delete(String taskRecordId) {
        TaskRecordEntity taskRecordEntity = new TaskRecordEntity();
        taskRecordEntity.setTaskRecordId(taskRecordId);
        taskRecordEntity.setIsDeleted(DeleteStatusEnum.DELETED.getStatus());
        return this.taskRecordEntityMapper.updateByPrimaryKeySelective((Object)taskRecordEntity);
    }

    public TaskRecordEntity get(String taskRecordId) {
        return (TaskRecordEntity)this.taskRecordEntityMapper.selectByPrimaryKey(taskRecordId);
    }

    public Integer deleteByTaskMainId(String taskMainId) {
        return this.taskRecordEntityMapper.deleteByTaskMainId(taskMainId);
    }

    public PageInfo<TaskRecordRespVo> getList(TaskRecordQueryReqVo taskRecordQueryReqVo) {
        PageHelper.startPage((int)taskRecordQueryReqVo.getCurrentPageNum(), (int)taskRecordQueryReqVo.getPageSize());
        TaskRecordEntity taskRecordEntity = (TaskRecordEntity)BeanCopyUtil.copy((Object)taskRecordQueryReqVo, TaskRecordEntity.class);
        List taskRecordEntities = this.taskRecordEntityMapper.selectList(taskRecordEntity);
        PageInfo pageInfo = new PageInfo(taskRecordEntities);
        List taskRecordRespVos = BeanCopyUtil.copyList((List)taskRecordEntities, TaskRecordRespVo.class);
        pageInfo.setList(taskRecordRespVos);
        pageInfo.setPageNum(taskRecordQueryReqVo.getCurrentPageNum());
        pageInfo.setPageSize(taskRecordQueryReqVo.getPageSize());
        return pageInfo;
    }

    public void post(MotionParameters motionParameters, String objectType, String objectName, String sourceSql, String targetSql, KeyValuePair keyValuePair) {
        TaskRecordEntity taskRecordEntity = new TaskRecordEntity();
        String taskRecordId = IdUtil.nextId();
        taskRecordEntity.setTaskMainId(motionParameters.taskMainId);
        taskRecordEntity.setTaskExectueSnapshotId(motionParameters.taskExectueSnapshotId);
        taskRecordEntity.setIsDeleted(DeleteStatusEnum.UNDELETED.getStatus());
        taskRecordEntity.setTaskRecordId(taskRecordId);
        taskRecordEntity.setTaskRecordType(objectType);
        taskRecordEntity.setStatus(keyValuePair.getKey());
        taskRecordEntity.setObjectName(objectName);
        taskRecordEntity.setConsumingTime(Integer.valueOf(0));
        taskRecordEntity.setExecuteTime(new Date());
        this.taskRecordEntityMapper.insertSelective((Object)taskRecordEntity);
        TaskLogEntity taskLogEntity = new TaskLogEntity();
        taskLogEntity.setTaskLogId(IdUtil.nextId());
        taskLogEntity.setTaskRecordId(taskRecordId);
        taskLogEntity.setSourceSql(sourceSql);
        taskLogEntity.setTargetSql(targetSql);
        taskLogEntity.setTaskLogContent(keyValuePair.getValue());
        taskLogEntity.setIsDeleted(DeleteStatusEnum.UNDELETED.getStatus());
        this.taskLogService.post((Object)taskLogEntity);
    }

    public void onApplicationEvent(SpringTaskExcuteEvent taskExcuteEvent) {
        this.post(taskExcuteEvent.motionParameters, taskExcuteEvent.objectType, taskExcuteEvent.objectName, taskExcuteEvent.sourceSql, taskExcuteEvent.targetSql, taskExcuteEvent.keyValuePair);
    }

    public TaskRecordEntity getFailRecordByTaskMainId(String taskMainId) {
        return this.taskRecordEntityMapper.seleteFailRecordByTaskMainId(taskMainId);
    }
}

