/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.controller;

import com.hundsun.lightdb.motion.base.Result;
import com.hundsun.lightdb.motion.service.DictionaryService;
import com.hundsun.lightdb.motion.vo.response.DictionaryRespVo;
import com.hundsun.lightdb.utils.BeanCopyUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dictionary"})
@Api(tags={"\u5b57\u5178"})
@ConditionalOnProperty(value={"etl.global.runModel"}, havingValue="1")
public class DictionaryController {
    @Autowired
    private DictionaryService dictionaryService;

    @RequestMapping(value={"/selectlist"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u67e5\u8be2\u5b57\u5178\u4fe1\u606f")
    public Result<List<DictionaryRespVo>> selectList(@RequestParam(value="types") String[] dictionaryTypes) {
        List<String> codes = Arrays.asList(dictionaryTypes);
        List dictionaryEntities = this.dictionaryService.getDictionaryByType(codes);
        List dictionaryRespVo = BeanCopyUtil.copyList((List)dictionaryEntities, DictionaryRespVo.class);
        dictionaryRespVo = dictionaryRespVo.stream().distinct().collect(Collectors.toList());
        return Result.success(dictionaryRespVo);
    }
}

