/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion;

import com.hundsun.lightdb.core.EtlDirector;
import com.hundsun.lightdb.core.MotionParameters;
import com.hundsun.lightdb.core.config.DbConfig;
import com.hundsun.lightdb.core.config.GlobalConfig;
import com.hundsun.lightdb.core.config.SqlDataCompareConfig;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.core.transformer.Ora2LightdbOracleTransformer;
import com.hundsun.lightdb.motion.factory.SourceFetcherFacorty;
import com.hundsun.lightdb.motion.factory.SourceJdbcMetaFacorty;
import com.hundsun.lightdb.motion.factory.TargetImporterFacorty;
import com.hundsun.lightdb.motion.factory.TargetJdbcMetaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotionTask {
    private static final Logger log = LoggerFactory.getLogger(MotionTask.class);
    GlobalConfig globalConfig;
    DbConfig source;
    DbConfig target;
    MotionParameters motionParameters;

    public void run() {
        SourceJdbcMeta sourceJdbcMeta = SourceJdbcMetaFacorty.getSourceJdbcMeta((String)this.globalConfig.getSourceDatabase(), (DbConfig)this.source);
        SourceFetcher sourceFetcher = SourceFetcherFacorty.getSourceFetcher((String)this.globalConfig.getSourceDatabase(), (SourceJdbcMeta)sourceJdbcMeta);
        Ora2LightdbOracleTransformer transformer = new Ora2LightdbOracleTransformer();
        TargetJdbcMeta targetJdbcMeta = TargetJdbcMetaFactory.getTargetJdbcMeta((String)this.globalConfig.getTargetDatabase(), (DbConfig)this.target);
        TargetImporter targetImporter = TargetImporterFacorty.getTargetImporter((String)this.globalConfig.getTargetDatabase(), (TargetJdbcMeta)targetJdbcMeta, (SourceJdbcMeta)sourceJdbcMeta);
        EtlDirector director = new EtlDirector(sourceFetcher, (EtlTransformer)transformer, targetImporter, this.globalConfig, new SqlDataCompareConfig(), this.motionParameters);
        try {
            director.run();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u4efb\u52a1\u542f\u52a8\u5931\u8d25 \u4efb\u52a1id:{} \u5feb\u7167id:{} \u9519\u8bef\u4fe1\u606f:{}", new Object[]{this.motionParameters.taskMainId, this.motionParameters.taskExectueSnapshotId, e});
            }
            throw new RuntimeException(e);
        }
    }

    public MotionTask(GlobalConfig globalConfig, DbConfig source, DbConfig target, MotionParameters motionParameters) {
        this.globalConfig = globalConfig;
        this.source = source;
        this.target = target;
        this.motionParameters = motionParameters;
    }
}

