/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.config;

import com.hundsun.lightdb.core.config.DbConfig;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.source.goldenmysql.GoldenMysqlSourceFetcher;
import com.hundsun.lightdb.core.source.goldenmysql.GoldenMysqlSourceJdbcMeta;
import com.hundsun.lightdb.core.source.lightdb.LightdbSourceFetcher;
import com.hundsun.lightdb.core.source.lightdb.LightdbSourceJdbcMeta;
import com.hundsun.lightdb.core.source.mysql.MysqlSourceFetcher;
import com.hundsun.lightdb.core.source.mysql.MysqlSourceJdbcMeta;
import com.hundsun.lightdb.core.source.mysql80.Mysql80SourceFetcher;
import com.hundsun.lightdb.core.source.mysql80.Mysql80SourceJdbcMeta;
import com.hundsun.lightdb.core.source.oracle.OracleSourceFetcher;
import com.hundsun.lightdb.core.source.oracle.OracleSourceJdbcMeta;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SourceConfig {
    @Bean
    @ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="mysql")
    public MysqlSourceJdbcMeta mysqlSourceJdbcMeta(@Qualifier(value="source") DbConfig dbConfig) {
        return new MysqlSourceJdbcMeta(dbConfig);
    }

    @Bean
    @ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="mysql")
    public MysqlSourceFetcher mysqlSourceFetcher(MysqlSourceJdbcMeta mysqlSourceJdbcMeta) {
        return new MysqlSourceFetcher((SourceJdbcMeta)mysqlSourceJdbcMeta);
    }

    @Bean
    @ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="mysql80")
    public Mysql80SourceJdbcMeta mysql80SourceJdbcMeta(@Qualifier(value="source") DbConfig dbConfig) {
        return new Mysql80SourceJdbcMeta(dbConfig);
    }

    @Bean
    @ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="mysql80")
    public Mysql80SourceFetcher mysql80SourceFetcher(Mysql80SourceJdbcMeta mysql80SourceJdbcMeta) {
        return new Mysql80SourceFetcher((SourceJdbcMeta)mysql80SourceJdbcMeta);
    }

    @Bean
    @ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="oracle")
    public OracleSourceJdbcMeta oracleSourceJdbcMeta(@Qualifier(value="source") DbConfig dbConfig) {
        return new OracleSourceJdbcMeta(dbConfig);
    }

    @Bean
    @ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="oracle")
    public OracleSourceFetcher oracleSourceFetcher(OracleSourceJdbcMeta oracleSourceJdbcMeta) {
        return new OracleSourceFetcher((SourceJdbcMeta)oracleSourceJdbcMeta);
    }

    @Bean
    @ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="golden-mysql")
    public GoldenMysqlSourceJdbcMeta goldenMysqlSourceJdbcMeta(@Qualifier(value="source") DbConfig dbConfig) {
        return new GoldenMysqlSourceJdbcMeta(dbConfig);
    }

    @Bean
    @ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="golden-mysql")
    public GoldenMysqlSourceFetcher goldenMysqlSourceFetcher(GoldenMysqlSourceJdbcMeta goldenMysqlSourceJdbcMeta) {
        return new GoldenMysqlSourceFetcher((SourceJdbcMeta)goldenMysqlSourceJdbcMeta);
    }

    @Bean
    @ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="lightdb")
    public LightdbSourceJdbcMeta lightdbSourceJdbcMeta(@Qualifier(value="source") DbConfig dbConfig, @Value(value="${etl.internal.driver-names.lightdb:classpath:drivers/ltjdbc.jar}") String driverJarName) {
        LightdbSourceJdbcMeta meta = new LightdbSourceJdbcMeta(dbConfig);
        meta.setDriverJarName(driverJarName);
        return meta;
    }

    @Bean
    @ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="lightdb")
    public LightdbSourceFetcher lightdbSourceFetcher(LightdbSourceJdbcMeta lightdbSourceJdbcMeta) {
        return new LightdbSourceFetcher((SourceJdbcMeta)lightdbSourceJdbcMeta);
    }
}

