/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.custom;

import com.goldendb.jdbc.AbandonedConnectionCleanupThread;
import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.HostInfo;
import com.goldendb.jdbc.internal.core.io.ConnectionImpl;
import com.goldendb.jdbc.internal.core.io.NonRegisteringDriver;
import com.goldendb.jdbc.internal.log.GoldendbLog;
import com.goldendb.jdbc.internal.log.LogFactory;
import com.goldendb.jdbc.internal.log.StandardLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackListManager
implements Runnable {
    private Map<String, HostInfo> monitorhostList = new HashMap<String, HostInfo>();
    private Map<String, HostInfo> blackhostList = new HashMap<String, HostInfo>();
    private static BlackListManager connMonitor = new BlackListManager();
    private static final ExecutorService ConnectionMonitorThreadExcecutorService;
    private static final ScheduledThreadPoolExecutor Executor;
    static Thread threadRef;

    public static BlackListManager getInstance() {
        return connMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitorHost(String hostPortPair, Properties props, Exception exception) throws SQLException {
        Throwable cause;
        if (null == props) {
            return;
        }
        Boolean useBlackList = Boolean.parseBoolean(props.getProperty("useBlackList", "true"));
        if (!useBlackList.booleanValue()) {
            return;
        }
        String errMsg = "";
        if (null != exception) {
            errMsg = exception.getMessage();
        }
        if (null != (cause = exception.getCause())) {
            errMsg = errMsg + "\n";
            errMsg = errMsg + cause.getMessage();
        }
        HostInfo monitorhost = new HostInfo(hostPortPair, props, errMsg);
        String key = monitorhost.getBlackHostKey();
        Map<String, HostInfo> map = this.monitorhostList;
        synchronized (map) {
            if (!this.monitorhostList.containsKey(key)) {
                this.monitorhostList.put(key, monitorhost);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitorHost(String hostPortPair) {
        Map<String, HostInfo> map = this.monitorhostList;
        synchronized (map) {
            if (this.monitorhostList.containsKey(hostPortPair)) {
                this.monitorhostList.remove(hostPortPair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlackHost(String hostPortPair, Properties props, String errMsg) throws SQLException {
        if (null == props) {
            return;
        }
        HostInfo blackhost = new HostInfo(hostPortPair, props, errMsg);
        String key = blackhost.getBlackHostKey();
        Map<String, HostInfo> map = this.blackhostList;
        synchronized (map) {
            if (!this.blackhostList.containsKey(key)) {
                this.blackhostList.put(key, blackhost);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlackHost(String hostPortPair) {
        Map<String, HostInfo> map = this.blackhostList;
        synchronized (map) {
            if (this.blackhostList.containsKey(hostPortPair)) {
                this.blackhostList.remove(hostPortPair);
            }
        }
    }

    public List<String> getMonitorHostPair() {
        ArrayList<String> monitorlistClone = new ArrayList<String>();
        Map<String, HostInfo> monitorList = BlackListManager.getInstance().getGlobalMonitorlist();
        for (Map.Entry<String, HostInfo> entry : monitorList.entrySet()) {
            HostInfo host = entry.getValue();
            monitorlistClone.add(host.getHostPair());
        }
        return monitorlistClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, HostInfo> getGlobalMonitorlist() {
        HashMap<String, HostInfo> monitorlistClone = new HashMap<String, HostInfo>(this.monitorhostList.size());
        Map<String, HostInfo> map = this.monitorhostList;
        synchronized (map) {
            monitorlistClone.putAll(this.monitorhostList);
        }
        return monitorlistClone;
    }

    public List<String> getBlackHostPair() {
        ArrayList<String> blacklistClone = new ArrayList<String>();
        Map<String, HostInfo> monitorList = BlackListManager.getInstance().getGlobalBlacklist();
        for (Map.Entry<String, HostInfo> entry : monitorList.entrySet()) {
            HostInfo host = entry.getValue();
            blacklistClone.add(host.getHostPair());
        }
        return blacklistClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, HostInfo> getGlobalBlacklist() {
        HashMap<String, HostInfo> blacklistClone = new HashMap<String, HostInfo>(this.blackhostList.size());
        Map<String, HostInfo> map = this.blackhostList;
        synchronized (map) {
            blacklistClone.putAll(this.blackhostList);
        }
        return blacklistClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isBlackHost(String Key2) {
        Boolean bExist = false;
        Map<String, HostInfo> map = this.blackhostList;
        synchronized (map) {
            bExist = this.blackhostList.containsKey(Key2);
        }
        return bExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostInfo getHostInfo(String Key2) {
        HostInfo newhostinfo = null;
        Map<String, HostInfo> map = this.blackhostList;
        synchronized (map) {
            if (this.blackhostList.containsKey(Key2)) {
                HostInfo hostinfo = this.blackhostList.get(Key2);
                try {
                    newhostinfo = new HostInfo(hostinfo.getHostPair(), hostinfo.getProperties(), hostinfo.getException());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return newhostinfo;
    }

    public String host(Properties props) {
        return props.getProperty("HOST", "localhost");
    }

    public int port(Properties props) {
        return Integer.parseInt(props.getProperty("PORT", "3306"));
    }

    private java.sql.Connection checkConn(HostInfo blackhost, int numRetries) {
        Connection newConn = null;
        Properties prop = null;
        GoldendbLog log = null;
        Boolean bPrintCount = false;
        for (int attempts = 0; attempts < numRetries; ++attempts) {
            String message;
            StringBuffer str;
            StackTraceElement[] stackElements;
            try {
                Properties props;
                prop = blackhost.getProperties();
                int connectTimeout = Integer.parseInt(prop.getProperty("connectTimeout", "10000"));
                int socketTimeout = Integer.parseInt(prop.getProperty("socketTimeout", "0"));
                connectTimeout = connectTimeout == 0 ? 5000 : connectTimeout;
                socketTimeout = socketTimeout == 0 ? 10000 : socketTimeout;
                String hostpair = blackhost.getHostPair();
                String logger = prop.getProperty("logger", StandardLogger.class.getName());
                log = LogFactory.getLogger(logger, "MySQL", null);
                String url = "jdbc:goldendb://" + hostpair + "/?useSSL=false&connectTimeout=" + connectTimeout + "&socketTimeout=" + socketTimeout;
                bPrintCount = Boolean.parseBoolean(prop.getProperty("printBlackListLog", "false"));
                if (bPrintCount.booleanValue()) {
                    Throwable ex = new Throwable();
                    StackTraceElement[] stackElements2 = ex.getStackTrace();
                    StringBuffer str2 = new StringBuffer();
                    if (stackElements2 != null && stackElements2.length > 0) {
                        for (int i = 0; i < 1; ++i) {
                            str2.append(stackElements2[i].getFileName() + "[");
                            str2.append(stackElements2[i].getLineNumber() + "]");
                        }
                    }
                    log.logInfo(str2 + " url = " + url + " " + prop.getProperty("user") + " " + prop.getProperty("password"));
                }
                if (null != (props = NonRegisteringDriver.parseURL(url, null))) {
                    props.setProperty("user", prop.getProperty("user"));
                    props.setProperty("password", prop.getProperty("password"));
                    newConn = ConnectionImpl.getInstance(this.host(props), this.port(props), props, null, url);
                }
                if (null == newConn) continue;
                return newConn;
            }
            catch (SQLException ex) {
                Throwable ex1 = new Throwable();
                stackElements = ex1.getStackTrace();
                str = new StringBuffer();
                if (stackElements != null && stackElements.length > 0) {
                    for (int i = 0; i < 1; ++i) {
                        str.append(stackElements[i].getFileName() + "[");
                        str.append(stackElements[i].getLineNumber() + "]");
                    }
                }
                message = ex.getMessage() + "\n" + ex.getCause();
                if (!bPrintCount.booleanValue() || null == log) continue;
                log.logInfo(str + " message " + message);
                continue;
            }
            catch (Exception ex) {
                Throwable ex1 = new Throwable();
                stackElements = ex1.getStackTrace();
                str = new StringBuffer();
                if (stackElements != null && stackElements.length > 0) {
                    for (int i = 0; i < 1; ++i) {
                        str.append(stackElements[i].getFileName() + "[");
                        str.append(stackElements[i].getLineNumber() + "]");
                    }
                }
                message = ex.getMessage() + "\n" + ex.getCause();
                if (!bPrintCount.booleanValue() || null == log) continue;
                log.logInfo(str + " message " + message);
            }
        }
        return null;
    }

    public void closeConn(java.sql.Connection conn) {
        try {
            if (null != conn && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            StringBuffer str;
            StackTraceElement[] stackElements;
            Throwable ex1;
            GoldendbLog log = null;
            Boolean bPrintCount = false;
            try {
                int intervalTime = 3000;
                Map<String, HostInfo> monitorList = BlackListManager.getInstance().getGlobalMonitorlist();
                for (Map.Entry<String, HostInfo> entry : monitorList.entrySet()) {
                    int i;
                    StackTraceElement[] stackElements2;
                    Throwable ex;
                    String key = entry.getKey();
                    HostInfo host = entry.getValue();
                    Properties props = host.getProperties();
                    intervalTime = Integer.parseInt(props.getProperty("intervalTime", "3000"));
                    bPrintCount = Boolean.parseBoolean(props.getProperty("printBlackListLog", "false"));
                    String logger = props.getProperty("logger", StandardLogger.class.getName());
                    log = LogFactory.getLogger(logger, "MySQL", null);
                    if (bPrintCount.booleanValue()) {
                        Throwable ex2 = new Throwable();
                        StackTraceElement[] stackElements3 = ex2.getStackTrace();
                        StringBuffer str2 = new StringBuffer();
                        if (stackElements3 != null && stackElements3.length > 0) {
                            for (int i2 = 0; i2 < 1; ++i2) {
                                str2.append(stackElements3[i2].getFileName() + "[");
                                str2.append(stackElements3[i2].getLineNumber() + "]");
                            }
                        }
                        log.logInfo(str2 + " check monitorList key = " + host.getHostPair() + ", value = " + host);
                    }
                    java.sql.Connection conn = null;
                    conn = this.checkConn(host, 3);
                    BlackListManager.getInstance().removeMonitorHost(key);
                    if (bPrintCount.booleanValue()) {
                        ex = new Throwable();
                        stackElements2 = ex.getStackTrace();
                        StringBuffer str3 = new StringBuffer();
                        if (stackElements2 != null && stackElements2.length > 0) {
                            for (i = 0; i < 1; ++i) {
                                str3.append(stackElements2[i].getFileName() + "[");
                                str3.append(stackElements2[i].getLineNumber() + "]");
                            }
                        }
                        log.logInfo(str3 + " remove monitorList key = " + host.getHostPair() + ", value = " + host);
                    }
                    if (null == conn && !BlackListManager.getInstance().isBlackHost(key).booleanValue()) {
                        ex = new Throwable();
                        stackElements2 = ex.getStackTrace();
                        StringBuffer str4 = new StringBuffer();
                        if (stackElements2 != null && stackElements2.length > 0) {
                            for (i = 0; i < 1; ++i) {
                                str4.append(stackElements2[i].getFileName() + "[");
                                str4.append(stackElements2[i].getLineNumber() + "]");
                            }
                        }
                        log.logInfo(str4 + " add blacklist key = " + host.getHostPair() + ", value = " + host);
                        String hostpair = host.getHostPair();
                        String exception = host.getException();
                        BlackListManager.getInstance().addBlackHost(hostpair, props, exception);
                        int blackListTime = Integer.parseInt(props.getProperty("blackTaskTime", "60"));
                        BlackListTask timeoutTask = new BlackListTask(key, blackListTime);
                        Executor.schedule(timeoutTask, (long)blackListTime, TimeUnit.SECONDS);
                    }
                    this.closeConn(conn);
                }
                Thread.sleep(intervalTime);
                continue;
            }
            catch (InterruptedException e) {
                threadRef = null;
                ex1 = new Throwable();
                stackElements = ex1.getStackTrace();
                str = new StringBuffer();
                if (stackElements != null && stackElements.length > 0) {
                    for (int i = 0; i < 1; ++i) {
                        str.append(stackElements[i].getFileName() + "[");
                        str.append(stackElements[i].getLineNumber() + "]");
                    }
                }
                String message = e.getMessage() + "\n" + e.getCause();
                if (bPrintCount.booleanValue() && null != log) {
                    log.logInfo(str + " message " + message);
                }
                return;
            }
            catch (Exception ex) {
                ex1 = new Throwable();
                stackElements = ex1.getStackTrace();
                str = new StringBuffer();
                if (stackElements != null && stackElements.length > 0) {
                    for (int i = 0; i < 1; ++i) {
                        str.append(stackElements[i].getFileName() + "[");
                        str.append(stackElements[i].getLineNumber() + "]");
                    }
                }
                String message = ex.getMessage() + "\n" + ex.getCause();
                if (!bPrintCount.booleanValue() || null == log) continue;
                log.logInfo(str + " message " + message);
                continue;
            }
            break;
        }
    }

    private static boolean consistentClassLoaders() {
        ClassLoader callerCtxClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader threadCtxClassLoader = threadRef.getContextClassLoader();
        return callerCtxClassLoader != null && threadCtxClassLoader != null && callerCtxClassLoader == threadCtxClassLoader;
    }

    public static void checkedShutdown() {
        BlackListManager.shutdown(true);
    }

    public static void uncheckedShutdown() {
        BlackListManager.shutdown(false);
    }

    private static void shutdown(boolean checked) {
        if (checked && !BlackListManager.consistentClassLoaders()) {
            return;
        }
        ConnectionMonitorThreadExcecutorService.shutdownNow();
    }

    @Deprecated
    public static void shutdown() {
        BlackListManager.checkedShutdown();
    }

    static {
        threadRef = null;
        ConnectionMonitorThreadExcecutorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Abandoned connection cleanup thread");
                t.setDaemon(true);
                t.setContextClassLoader(AbandonedConnectionCleanupThread.class.getClassLoader());
                threadRef = t;
                return threadRef;
            }
        });
        ConnectionMonitorThreadExcecutorService.execute(new BlackListManager());
        Executor = new ScheduledThreadPoolExecutor(10, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("BlackListTask thread");
                return thread;
            }
        });
    }

    class BlackListTask
    implements Runnable {
        String key;
        int blackListTime;

        BlackListTask(String hostpair, int time) {
            this.key = hostpair;
            this.blackListTime = time;
        }

        public void run() {
            HostInfo hostinfo = BlackListManager.getInstance().getHostInfo(this.key);
            if (null != hostinfo) {
                java.sql.Connection conn = null;
                try {
                    int i;
                    StringBuffer str;
                    StackTraceElement[] stackElements;
                    Throwable ex;
                    Properties props = hostinfo.getProperties();
                    Boolean bPrintCount = Boolean.parseBoolean(props.getProperty("printBlackListLog", "false"));
                    String logger = props.getProperty("logger", StandardLogger.class.getName());
                    GoldendbLog log = LogFactory.getLogger(logger, "MySQL", null);
                    if (bPrintCount.booleanValue()) {
                        ex = new Throwable();
                        stackElements = ex.getStackTrace();
                        str = new StringBuffer();
                        if (stackElements != null && stackElements.length > 0) {
                            for (i = 0; i < 1; ++i) {
                                str.append(stackElements[i].getFileName() + "[");
                                str.append(stackElements[i].getLineNumber() + "]");
                            }
                        }
                        log.logInfo(str + " check blacklist key = " + hostinfo.getHostPair() + ", value = " + hostinfo);
                    }
                    if (null != (conn = BlackListManager.this.checkConn(hostinfo, 1))) {
                        ex = new Throwable();
                        stackElements = ex.getStackTrace();
                        str = new StringBuffer();
                        if (stackElements != null && stackElements.length > 0) {
                            for (i = 0; i < 1; ++i) {
                                str.append(stackElements[i].getFileName() + "[");
                                str.append(stackElements[i].getLineNumber() + "]");
                            }
                        }
                        log.logInfo(str + " remove blacklist key = " + hostinfo.getHostPair() + ", value = " + hostinfo);
                        BlackListManager.getInstance().removeBlackHost(this.key);
                        BlackListManager.this.closeConn(conn);
                    } else {
                        Executor.schedule(new BlackListTask(this.key, this.blackListTime), (long)this.blackListTime, TimeUnit.SECONDS);
                    }
                }
                catch (Exception e) {
                    Executor.schedule(new BlackListTask(this.key, this.blackListTime), (long)this.blackListTime, TimeUnit.SECONDS);
                }
            }
        }
    }
}

