/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc;

import com.goldendb.jdbc.BalanceStrategy;
import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.internal.core.io.ConnectionImpl;
import com.goldendb.jdbc.internal.core.loadbalance.LoadBalancedConnectionProxy;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialBalanceStrategy
implements BalanceStrategy {
    private int currentHostIndex = -1;

    @Override
    public void destroy() {
    }

    @Override
    public void init(Connection conn, Properties props) throws SQLException {
    }

    @Override
    public ConnectionImpl pickConnection(LoadBalancedConnectionProxy proxy, List<String> configuredHosts, Map<String, ConnectionImpl> liveConnections, long[] responseTimes, int numRetries) throws SQLException {
        ConnectionImpl conn;
        int numHosts = configuredHosts.size();
        SQLException ex = null;
        Map<String, Long> blackList = proxy.getGlobalBlacklist();
        int attempts = 0;
        while (true) {
            int i;
            if (attempts >= numRetries) {
                if (ex != null) {
                    throw ex;
                }
                return null;
            }
            if (numHosts == 1) {
                this.currentHostIndex = 0;
            } else if (this.currentHostIndex == -1) {
                int j;
                for (j = i = (int)Math.floor(Math.random() * (double)numHosts); j < numHosts; ++j) {
                    if (blackList.containsKey(configuredHosts.get(j))) continue;
                    this.currentHostIndex = j;
                    break;
                }
                if (this.currentHostIndex == -1) {
                    for (j = 0; j < i; ++j) {
                        if (blackList.containsKey(configuredHosts.get(j))) continue;
                        this.currentHostIndex = j;
                        break;
                    }
                }
                if (this.currentHostIndex == -1) {
                    blackList = proxy.getGlobalBlacklist();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException var16) {}
                    continue;
                }
            } else {
                boolean foundGoodHost = false;
                for (i = this.currentHostIndex + 1; i < numHosts; ++i) {
                    if (blackList.containsKey(configuredHosts.get(i))) continue;
                    this.currentHostIndex = i;
                    foundGoodHost = true;
                    break;
                }
                if (!foundGoodHost) {
                    for (i = 0; i < this.currentHostIndex; ++i) {
                        if (blackList.containsKey(configuredHosts.get(i))) continue;
                        this.currentHostIndex = i;
                        foundGoodHost = true;
                        break;
                    }
                }
                if (!foundGoodHost) {
                    blackList = proxy.getGlobalBlacklist();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException var15) {}
                    continue;
                }
            }
            String hostPortSpec = configuredHosts.get(this.currentHostIndex);
            conn = liveConnections.get(hostPortSpec);
            if (conn != null) break;
            try {
                conn = proxy.createConnectionForHost(hostPortSpec);
            }
            catch (SQLException var17) {
                ex = var17;
                if (!proxy.shouldExceptionTriggerConnectionSwitch(var17)) {
                    throw var17;
                }
                proxy.addToGlobalBlacklist(hostPortSpec);
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException var14) {}
                continue;
            }
            break;
        }
        return conn;
    }
}

