/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class JDK8Util {
    public static OffsetDateTime castTimestampToOffsetDateTime(Timestamp timestamp, TimeZone timeZone) {
        Instant instant = timestamp.toInstant();
        int offsetMillis = timeZone.getRawOffset();
        int offsetHours = (int)TimeUnit.MILLISECONDS.toHours(offsetMillis);
        ZoneOffset zoneOffset = ZoneOffset.ofHours(offsetHours);
        OffsetDateTime offsetDateTime = instant.atOffset(zoneOffset);
        return offsetDateTime;
    }

    public static Timestamp castOffsetDateTimeToTimestamp(Object offsetDateTime) {
        return Timestamp.from(((OffsetDateTime)offsetDateTime).toInstant());
    }
}

