/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc;

import com.goldendb.jdbc.internal.core.io.NonRegisteringDriver;
import java.sql.SQLException;
import java.util.Properties;

public class HostInfo {
    String host = "";
    String port = "3306";
    String user = "";
    String passwd = "";
    String exception = "";
    Properties props = null;

    public HostInfo(String hostPortSpec, Properties props, String exception) throws SQLException {
        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(hostPortSpec);
        this.host = hostPortPair[0];
        this.port = hostPortPair[1];
        this.passwd = props.getProperty("password");
        this.user = props.getProperty("user");
        this.props = props;
        this.exception = exception;
    }

    public String getHostPair() {
        String key = this.host;
        if (null != this.port) {
            key = key + ":" + this.port;
        }
        return key;
    }

    public String getBlackHostKey() {
        String key = this.host;
        if (null != this.port) {
            key = key + ":" + this.port;
        }
        key = key + ":" + this.user + ":" + this.passwd;
        return key;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getException() {
        return this.exception;
    }
}

