/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc;

import com.goldendb.jdbc.ExceptionInterceptor;
import com.goldendb.jdbc.Util;
import com.goldendb.jdbc.internal.core.io.ConnectionImpl;
import com.goldendb.jdbc.internal.core.io.MysqlIO;
import com.goldendb.jdbc.internal.core.io.SocketFactory;
import com.goldendb.jdbc.internal.core.io.SocketMetadata;
import com.goldendb.jdbc.internal.util.Base64Decoder;
import com.goldendb.jdbc.internal.util.SQLError;
import com.goldendb.jdbc.internal.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportControlled {
    private static final String SQL_STATE_BAD_SSL_PARAMS = "08000";
    private static final String TLSv1 = "TLSv1";
    private static final String TLSv1_1 = "TLSv1.1";
    private static final String TLSv1_2 = "TLSv1.2";
    private static final String TLSv1_3 = "TLSv1.3";
    private static final String[] KNOWN_TLS_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"};
    private static final String[] VALID_TLS_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2"};

    public static boolean enabled() {
        return true;
    }

    public static void transformSocketToSSLSocket(MysqlIO mysqlIO) throws SQLException {
        StandardSSLSocketFactory sslFact = new StandardSSLSocketFactory(ExportControlled.getSSLSocketFactoryDefaultOrConfigured(mysqlIO), mysqlIO.socketFactory, mysqlIO.mysqlConnection);
        try {
            mysqlIO.mysqlConnection = sslFact.connect(mysqlIO.host, mysqlIO.port, null);
            List<String> tryProtocols = null;
            String enabledTLSProtocols = mysqlIO.connection.getEnabledTLSProtocols();
            tryProtocols = enabledTLSProtocols != null && enabledTLSProtocols.length() > 0 ? ExportControlled.getValidProtocols(mysqlIO, enabledTLSProtocols.split("\\s*,\\s*")) : new ArrayList<String>(Arrays.asList(VALID_TLS_PROTOCOLS));
            List<String> jvmSupportedProtocols = Arrays.asList(((SSLSocket)mysqlIO.mysqlConnection).getSupportedProtocols());
            ArrayList<String> allowedProtocols = new ArrayList<String>();
            for (String protocol : tryProtocols) {
                if (!jvmSupportedProtocols.contains(protocol)) continue;
                allowedProtocols.add(protocol);
            }
            ((SSLSocket)mysqlIO.mysqlConnection).setEnabledProtocols(allowedProtocols.toArray(new String[0]));
            String enabledSSLCipherSuites = mysqlIO.connection.getEnabledSSLCipherSuites();
            boolean overrideCiphers = enabledSSLCipherSuites != null && enabledSSLCipherSuites.length() > 0;
            ArrayList<String> allowedCiphers = null;
            if (overrideCiphers) {
                allowedCiphers = new ArrayList<String>();
                List<String> availableCiphers = Arrays.asList(((SSLSocket)mysqlIO.mysqlConnection).getEnabledCipherSuites());
                for (String cipher : enabledSSLCipherSuites.split("\\s*,\\s*")) {
                    if (!availableCiphers.contains(cipher)) continue;
                    allowedCiphers.add(cipher);
                }
            } else {
                boolean disableDHAlgorithm = false;
                if (!(mysqlIO.versionMeetsMinimum(5, 5, 45) && !mysqlIO.versionMeetsMinimum(5, 6, 0) || mysqlIO.versionMeetsMinimum(5, 6, 26) && !mysqlIO.versionMeetsMinimum(5, 7, 0) || mysqlIO.versionMeetsMinimum(5, 7, 6))) {
                    if (Util.getJVMVersion() >= 8) {
                        disableDHAlgorithm = true;
                    }
                } else if (Util.getJVMVersion() < 8) {
                    disableDHAlgorithm = true;
                }
                if (disableDHAlgorithm) {
                    allowedCiphers = new ArrayList();
                    for (String cipher : ((SSLSocket)mysqlIO.mysqlConnection).getEnabledCipherSuites()) {
                        if (disableDHAlgorithm && (cipher.indexOf("_DHE_") > -1 || cipher.indexOf("_DH_") > -1)) continue;
                        allowedCiphers.add(cipher);
                    }
                }
            }
            if (allowedCiphers != null) {
                ((SSLSocket)mysqlIO.mysqlConnection).setEnabledCipherSuites(allowedCiphers.toArray(new String[0]));
            }
            ((SSLSocket)mysqlIO.mysqlConnection).startHandshake();
            mysqlIO.mysqlInput = mysqlIO.connection.getUseUnbufferedInput() ? mysqlIO.mysqlConnection.getInputStream() : new BufferedInputStream(mysqlIO.mysqlConnection.getInputStream(), 16384);
            mysqlIO.mysqlOutput = new BufferedOutputStream(mysqlIO.mysqlConnection.getOutputStream(), 16384);
            mysqlIO.mysqlOutput.flush();
            mysqlIO.socketFactory = sslFact;
        }
        catch (IOException var14) {
            throw SQLError.createCommunicationsException(mysqlIO.connection, mysqlIO.getLastPacketSentTimeMs(), mysqlIO.getLastPacketReceivedTimeMs(), var14, mysqlIO.getExceptionInterceptor());
        }
    }

    private static List<String> getValidProtocols(MysqlIO mysqlIO, String[] protocols) throws SQLException {
        ArrayList<String> configuredProtocols = new ArrayList<String>(Arrays.asList(protocols));
        if (configuredProtocols.size() == 0) {
            throw SQLError.createSQLException("Specified list of TLS versions is empty. Accepted values are TLSv1.2 and TLSv1.3.", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
        }
        ArrayList<String> allowedProtocols = new ArrayList<String>();
        for (String protocol : KNOWN_TLS_PROTOCOLS) {
            if (!configuredProtocols.contains(protocol)) continue;
            allowedProtocols.add(protocol);
        }
        if (allowedProtocols.size() == 0) {
            throw SQLError.createSQLException("Specified list of TLS versions only contains non valid TLS protocols. Accepted values are TLSv1.2 and TLSv1.3.", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
        }
        ArrayList<String> validProtocols = new ArrayList<String>();
        for (String protocol : VALID_TLS_PROTOCOLS) {
            if (!allowedProtocols.contains(protocol)) continue;
            validProtocols.add(protocol);
        }
        if (validProtocols.size() == 0) {
            throw SQLError.createSQLException("TLS protocols TLSv1 and TLSv1.1 are not supported. Accepted values are TLSv1.2 and TLSv1.3.", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
        }
        return validProtocols;
    }

    private ExportControlled() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SSLSocketFactory getSSLSocketFactoryDefaultOrConfigured(MysqlIO mysqlIO) throws SQLException {
        ArrayList<TrustManager> tms;
        KeyManager[] kms;
        block44: {
            KeyStore trustKeyStore;
            InputStream trustStoreIS;
            TrustManagerFactory tmf;
            String trustCertificateKeyStoreType;
            String trustCertificateKeyStorePassword;
            String trustCertificateKeyStoreUrl;
            block43: {
                String clientCertificateKeyStoreUrl = mysqlIO.connection.getClientCertificateKeyStoreUrl();
                String clientCertificateKeyStorePassword = mysqlIO.connection.getClientCertificateKeyStorePassword();
                String clientCertificateKeyStoreType = mysqlIO.connection.getClientCertificateKeyStoreType();
                trustCertificateKeyStoreUrl = mysqlIO.connection.getTrustCertificateKeyStoreUrl();
                trustCertificateKeyStorePassword = mysqlIO.connection.getTrustCertificateKeyStorePassword();
                trustCertificateKeyStoreType = mysqlIO.connection.getTrustCertificateKeyStoreType();
                if (StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl)) {
                    clientCertificateKeyStoreUrl = System.getProperty("javax.net.ssl.keyStore");
                    clientCertificateKeyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
                    clientCertificateKeyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
                    if (StringUtils.isNullOrEmpty(clientCertificateKeyStoreType)) {
                        clientCertificateKeyStoreType = "JKS";
                    }
                    if (!StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl)) {
                        try {
                            new URL(clientCertificateKeyStoreUrl);
                        }
                        catch (MalformedURLException var78) {
                            clientCertificateKeyStoreUrl = "file:" + clientCertificateKeyStoreUrl;
                        }
                    }
                }
                if (StringUtils.isNullOrEmpty(trustCertificateKeyStoreUrl)) {
                    trustCertificateKeyStoreUrl = System.getProperty("javax.net.ssl.trustStore");
                    trustCertificateKeyStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                    trustCertificateKeyStoreType = System.getProperty("javax.net.ssl.trustStoreType");
                    if (StringUtils.isNullOrEmpty(trustCertificateKeyStoreType)) {
                        trustCertificateKeyStoreType = "JKS";
                    }
                    if (!StringUtils.isNullOrEmpty(trustCertificateKeyStoreUrl)) {
                        try {
                            new URL(trustCertificateKeyStoreUrl);
                        }
                        catch (MalformedURLException var77) {
                            trustCertificateKeyStoreUrl = "file:" + trustCertificateKeyStoreUrl;
                        }
                    }
                }
                tmf = null;
                KeyManagerFactory kmf = null;
                kms = null;
                tms = new ArrayList<TrustManager>();
                try {
                    tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                }
                catch (NoSuchAlgorithmException var76) {
                    throw SQLError.createSQLException("Default algorithm definitions for TrustManager and/or KeyManager are invalid.  Check java security properties file.", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                }
                if (!StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl)) {
                    trustStoreIS = null;
                    try {
                        try {
                            if (!StringUtils.isNullOrEmpty(clientCertificateKeyStoreType)) {
                                trustKeyStore = KeyStore.getInstance(clientCertificateKeyStoreType);
                                URL ksURL = new URL(clientCertificateKeyStoreUrl);
                                char[] password = clientCertificateKeyStorePassword == null ? new char[]{} : clientCertificateKeyStorePassword.toCharArray();
                                trustStoreIS = ksURL.openStream();
                                trustKeyStore.load(trustStoreIS, password);
                                kmf.init(trustKeyStore, password);
                                kms = kmf.getKeyManagers();
                            }
                        }
                        catch (UnrecoverableKeyException var70) {
                            throw SQLError.createSQLException("Could not recover keys from client keystore.  Check password?", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                        }
                        catch (NoSuchAlgorithmException var71) {
                            throw SQLError.createSQLException("Unsupported keystore algorithm [" + var71.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                        }
                        catch (KeyStoreException var72) {
                            throw SQLError.createSQLException("Could not create KeyStore instance [" + var72.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                        }
                        catch (CertificateException var73) {
                            throw SQLError.createSQLException("Could not load client" + clientCertificateKeyStoreType + " keystore from " + clientCertificateKeyStoreUrl, mysqlIO.getExceptionInterceptor());
                        }
                        catch (MalformedURLException var74) {
                            throw SQLError.createSQLException(clientCertificateKeyStoreUrl + " does not appear to be a valid URL.", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                        }
                        catch (IOException var75) {
                            SQLException sqlEx = SQLError.createSQLException("Cannot open " + clientCertificateKeyStoreUrl + " [" + var75.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                            sqlEx.initCause(var75);
                            throw sqlEx;
                        }
                        Object var17_32 = null;
                        if (trustStoreIS == null) break block43;
                    }
                    catch (Throwable throwable) {
                        Object var17_33 = null;
                        if (trustStoreIS == null) throw throwable;
                        try {
                            trustStoreIS.close();
                            throw throwable;
                        }
                        catch (IOException var66) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException var66) {}
                    trustStoreIS.close();
                }
            }
            trustStoreIS = null;
            try {
                try {
                    trustKeyStore = null;
                    if (!StringUtils.isNullOrEmpty(trustCertificateKeyStoreUrl) && !StringUtils.isNullOrEmpty(trustCertificateKeyStoreType)) {
                        trustStoreIS = new URL(trustCertificateKeyStoreUrl).openStream();
                        char[] trustStorePassword = trustCertificateKeyStorePassword == null ? new char[]{} : trustCertificateKeyStorePassword.toCharArray();
                        trustKeyStore = KeyStore.getInstance(trustCertificateKeyStoreType);
                        trustKeyStore.load(trustStoreIS, trustStorePassword);
                    }
                    tmf.init(trustKeyStore);
                    TrustManager[] origTms = tmf.getTrustManagers();
                    boolean verifyServerCert = mysqlIO.connection.getVerifyServerCertificate();
                    TrustManager[] arr$ = origTms;
                    int len$ = origTms.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        TrustManager tm = arr$[i$];
                        tms.add(tm instanceof X509TrustManager ? new X509TrustManagerWrapper((X509TrustManager)tm, verifyServerCert) : tm);
                    }
                    Object var21_43 = null;
                    if (trustStoreIS == null) break block44;
                }
                catch (MalformedURLException var80) {
                    throw SQLError.createSQLException(trustCertificateKeyStoreUrl + " does not appear to be a valid URL.", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                }
                catch (KeyStoreException var81) {
                    throw SQLError.createSQLException("Could not create KeyStore instance [" + var81.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                }
                catch (NoSuchAlgorithmException var82) {
                    throw SQLError.createSQLException("Unsupported keystore algorithm [" + var82.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                }
                catch (CertificateException var83) {
                    throw SQLError.createSQLException("Could not load trust" + trustCertificateKeyStoreType + " keystore from " + trustCertificateKeyStoreUrl, SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                }
                catch (IOException var84) {
                    SQLException sqlEx = SQLError.createSQLException("Cannot open " + trustCertificateKeyStoreType + " [" + var84.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                    sqlEx.initCause(var84);
                    throw sqlEx;
                }
            }
            catch (Throwable throwable) {
                Object var21_44 = null;
                if (trustStoreIS == null) throw throwable;
                try {
                    trustStoreIS.close();
                    throw throwable;
                }
                catch (IOException var67) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException var67) {}
            trustStoreIS.close();
        }
        if (tms.size() == 0) {
            tms.add(new X509TrustManagerWrapper());
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kms, tms.toArray(new TrustManager[tms.size()]), null);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException var68) {
            throw SQLError.createSQLException("TLS is not a valid SSL protocol.", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
        }
        catch (KeyManagementException var69) {
            throw SQLError.createSQLException("KeyManagementException: " + var69.getMessage(), SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
        }
    }

    public static boolean isSSLEstablished(MysqlIO mysqlIO) {
        return mysqlIO.mysqlConnection == null ? false : SSLSocket.class.isAssignableFrom(mysqlIO.mysqlConnection.getClass());
    }

    public static RSAPublicKey decodeRSAPublicKey(String key, ExceptionInterceptor interceptor) throws SQLException {
        try {
            if (key == null) {
                throw new SQLException("key parameter is null");
            }
            int offset = key.indexOf("\n") + 1;
            int len = key.indexOf("-----END PUBLIC KEY-----") - offset;
            byte[] certificateData = Base64Decoder.decode(key.getBytes(), offset, len);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(certificateData);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)kf.generatePublic(spec);
        }
        catch (Exception var7) {
            throw SQLError.createSQLException("Unable to decode public key", "S1009", var7, interceptor);
        }
    }

    public static byte[] encryptWithRSAPublicKey(byte[] source, RSAPublicKey key, String transformation, ExceptionInterceptor interceptor) throws SQLException {
        try {
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(1, key);
            return cipher.doFinal(source);
        }
        catch (Exception var5) {
            throw SQLError.createSQLException(var5.getMessage(), "S1009", var5, interceptor);
        }
    }

    public static class X509TrustManagerWrapper
    implements X509TrustManager {
        private X509TrustManager origTm = null;
        private boolean verifyServerCert = false;
        private CertificateFactory certFactory = null;
        private PKIXParameters validatorParams = null;
        private CertPathValidator validator = null;

        public X509TrustManagerWrapper(X509TrustManager tm, boolean verifyServerCertificate) throws CertificateException {
            this.origTm = tm;
            this.verifyServerCert = verifyServerCertificate;
            if (verifyServerCertificate) {
                try {
                    HashSet<TrustAnchor> anch = new HashSet<TrustAnchor>();
                    for (X509Certificate cert : tm.getAcceptedIssuers()) {
                        anch.add(new TrustAnchor(cert, null));
                    }
                    this.validatorParams = new PKIXParameters(anch);
                    this.validatorParams.setRevocationEnabled(false);
                    this.validator = CertPathValidator.getInstance("PKIX");
                    this.certFactory = CertificateFactory.getInstance("X.509");
                }
                catch (Exception var10) {
                    throw new CertificateException(var10);
                }
            }
        }

        public X509TrustManagerWrapper() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.origTm != null ? this.origTm.getAcceptedIssuers() : new X509Certificate[]{};
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            X509Certificate[] arr$ = chain;
            int len$ = chain.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                X509Certificate x509Certificate = arr$[i$];
                x509Certificate.checkValidity();
            }
            if (this.validatorParams != null) {
                X509CertSelector certSelect = new X509CertSelector();
                certSelect.setSerialNumber(chain[0].getSerialNumber());
                try {
                    CertPath certPath = this.certFactory.generateCertPath(Arrays.asList(chain));
                    CertPathValidatorResult result = this.validator.validate(certPath, this.validatorParams);
                    ((PKIXCertPathValidatorResult)result).getTrustAnchor().getTrustedCert().checkValidity();
                }
                catch (InvalidAlgorithmParameterException var7) {
                    throw new CertificateException(var7);
                }
                catch (CertPathValidatorException var8) {
                    throw new CertificateException(var8);
                }
            }
            if (this.verifyServerCert) {
                this.origTm.checkServerTrusted(chain, authType);
            }
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.origTm.checkClientTrusted(chain, authType);
        }
    }

    public static class StandardSSLSocketFactory
    implements SocketFactory,
    SocketMetadata {
        private SSLSocket rawSocket = null;
        private final SSLSocketFactory sslFact;
        private final SocketFactory existingSocketFactory;
        private final Socket existingSocket;

        public StandardSSLSocketFactory(SSLSocketFactory sslFact, SocketFactory existingSocketFactory, Socket existingSocket) {
            this.sslFact = sslFact;
            this.existingSocketFactory = existingSocketFactory;
            this.existingSocket = existingSocket;
        }

        public Socket afterHandshake() throws SocketException, IOException {
            this.existingSocketFactory.afterHandshake();
            return this.rawSocket;
        }

        public Socket beforeHandshake() throws SocketException, IOException {
            return this.rawSocket;
        }

        public Socket connect(String host, int portNumber, Properties props) throws SocketException, IOException {
            this.rawSocket = (SSLSocket)this.sslFact.createSocket(this.existingSocket, host, portNumber, true);
            return this.rawSocket;
        }

        public boolean isLocallyConnected(ConnectionImpl conn) throws SQLException {
            return SocketMetadata.Helper.isLocallyConnected(conn);
        }
    }
}

