/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.util;

import com.huawei.opengauss.jdbc.core.BaseConnection;
import com.huawei.opengauss.jdbc.jdbc.PgArray;
import com.huawei.opengauss.jdbc.jdbc.TypeNode;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PGobject
implements Serializable,
Cloneable {
    protected String type;
    protected String value;
    protected BaseConnection connection = null;
    protected Object[] struct;
    private String[] arrayValue;
    private TypeNode typeNode;
    private Object[] attributes;

    public PGobject() {
    }

    public PGobject(String value, TypeNode typeNode, BaseConnection connection) {
        this.connection = connection;
        this.typeNode = typeNode;
        this.value = value;
        if (typeNode != null && typeNode.getColumnList().size() > 0) {
            List<TypeNode> colmList = typeNode.getColumnList();
            ArrayList<String> objects = new ArrayList<String>();
            for (int i = 0; i < colmList.size(); ++i) {
                objects.add(colmList.get(i).getName());
            }
            this.setStruct(objects.toArray());
        }
    }

    public final void setType(String type) {
        this.type = type;
    }

    public void setValue(String value) throws SQLException {
        this.value = value;
    }

    public final String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public final void setStruct(Object[] struct) {
        this.struct = struct;
    }

    public final Object[] getStruct() {
        return this.struct;
    }

    public String[] getArrayValue() {
        if (this.arrayValue != null) {
            return this.arrayValue;
        }
        if (this.struct != null && this.struct.length > 0 && this.value.length() > 2) {
            this.arrayValue = new String[this.struct.length];
            char[] chars = this.value.toCharArray();
            int noBeginAndEndBracketLen = chars.length - 1;
            int begin = 1;
            int end = 1;
            int index = 0;
            int charCount = 0;
            block0: for (int i = 1; i < noBeginAndEndBracketLen; ++i) {
                if (chars[i] == '\"') {
                    ++charCount;
                    while (i + 2 <= noBeginAndEndBracketLen) {
                        if (chars[i + 1] == '\"') {
                            if (++charCount % 2 == 0 && (i + 2 == noBeginAndEndBracketLen || chars[i + 2] == ',')) {
                                end = i += 2;
                                this.arrayValue[index] = this.delimitedCompositeTypeValue(begin, end, this.value);
                                ++index;
                                begin = end + 1;
                                continue block0;
                            }
                            if (charCount % 2 == 0 && chars[i + 2] != '\"') {
                                this.arrayValue = new String[]{this.value};
                                return new String[]{this.value};
                            }
                            ++i;
                            continue;
                        }
                        ++i;
                    }
                    continue;
                }
                if (chars[i] != ',') continue;
                end = i;
                this.arrayValue[index] = this.delimitedCompositeTypeValue(begin, end, this.value);
                ++index;
                begin = end + 1;
            }
            if (end != noBeginAndEndBracketLen) {
                this.arrayValue[index] = this.delimitedCompositeTypeValue(begin, noBeginAndEndBracketLen, this.value);
            }
        } else {
            this.arrayValue = new String[]{this.value};
        }
        return this.arrayValue;
    }

    private String delimitedCompositeTypeValue(int begin, int end, String originalChar) {
        String attribute = originalChar.substring(begin, end);
        return attribute != null && attribute.length() > 0 ? attribute : null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGobject) {
            String otherValue = ((PGobject)obj).getValue();
            if (otherValue == null) {
                return this.getValue() == null;
            }
            return otherValue.equals(this.getValue());
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.getValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public Object[] getAttributes() throws SQLException {
        if (this.attributes == null) {
            this.attributes = new Object[this.typeNode.getColumnList().size()];
            this.parseResult(this.attributes);
        }
        return this.attributes;
    }

    public void parseResult(Object[] valueList) throws SQLException {
        List<TypeNode> columnList = this.typeNode.getColumnList();
        for (int i = 0; i < columnList.size(); ++i) {
            TypeNode nowType = columnList.get(i);
            if (nowType.isRecordType()) {
                String tempValue = this.getArrayValue()[i];
                tempValue = TypeNode.removeQuotationMarks(tempValue);
                PGobject pGobject = new PGobject(tempValue, nowType, this.connection);
                valueList[i] = pGobject;
                continue;
            }
            if (nowType.isBaseType()) {
                valueList[i] = TypeNode.removeQuotationMarks(this.getArrayValue()[i]);
                continue;
            }
            if (!nowType.isArrayType() && !nowType.isTableType()) continue;
            PgArray pgArray = new PgArray(this.connection, nowType.getOid(), TypeNode.removeQuotationMarks(this.getArrayValue()[i]), nowType);
            valueList[i] = pgArray;
        }
    }
}

