/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.util;

import com.huawei.opengauss.jdbc.PGProperty;
import com.huawei.opengauss.jdbc.util.OracleCompatibilityTag;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;

public class OracleCompatibilityTagsParser {
    public static final String ON = "ON";
    public static final String OFF = "OFF";

    public static Set<OracleCompatibilityTag> parseOracleCompatibilityTags(Properties info) {
        String[] tagNames;
        String oracleCompatible = PGProperty.ORACLE_COMPATIBLE.get(info);
        if (oracleCompatible == null || oracleCompatible.isEmpty() || Boolean.FALSE.toString().equalsIgnoreCase(oracleCompatible) || OFF.equalsIgnoreCase(oracleCompatible)) {
            return EnumSet.noneOf(OracleCompatibilityTag.class);
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(oracleCompatible) || ON.equalsIgnoreCase(oracleCompatible)) {
            return EnumSet.allOf(OracleCompatibilityTag.class);
        }
        EnumSet<OracleCompatibilityTag> tags = EnumSet.noneOf(OracleCompatibilityTag.class);
        for (String name : tagNames = oracleCompatible.split(",")) {
            OracleCompatibilityTag tag = OracleCompatibilityTag.getValue(name);
            tags.add(tag);
        }
        return tags;
    }
}

