/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.jdbc;

import com.huawei.opengauss.jdbc.Driver;
import com.huawei.opengauss.jdbc.core.BaseConnection;
import com.huawei.opengauss.jdbc.util.GT;
import com.huawei.opengauss.jdbc.util.PSQLException;
import com.huawei.opengauss.jdbc.util.PSQLState;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class PgParameterMetaData
implements ParameterMetaData {
    private final BaseConnection _connection;
    private final int[] _oids;

    public PgParameterMetaData(BaseConnection connection, int[] oids) {
        this._connection = connection;
        this._oids = oids;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkParamIndex(param);
        return this._connection.getTypeInfo().getJavaClass(this._oids[param - 1]);
    }

    @Override
    public int getParameterCount() {
        return this._oids.length;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkParamIndex(param);
        return 1;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkParamIndex(param);
        return this._connection.getTypeInfo().getSQLType(this._oids[param - 1]);
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkParamIndex(param);
        return this._connection.getTypeInfo().getPGType(this._oids[param - 1]);
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkParamIndex(param);
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkParamIndex(param);
        return this._connection.getTypeInfo().isSigned(this._oids[param - 1]);
    }

    private void checkParamIndex(int param) throws PSQLException {
        if (param < 1 || param > this._oids.length) {
            throw new PSQLException(GT.tr("The parameter index is out of range: {0}, number of parameters: {1}.", param, this._oids.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "isWrapperFor(Class<?>)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "unwrap(Class<?>)");
    }
}

