/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.core;

import com.huawei.opengauss.jdbc.GlobalConnectionTracker;
import com.huawei.opengauss.jdbc.PGNotification;
import com.huawei.opengauss.jdbc.PGProperty;
import com.huawei.opengauss.jdbc.core.BaseQueryKey;
import com.huawei.opengauss.jdbc.core.CachedQuery;
import com.huawei.opengauss.jdbc.core.CachedQueryCreateAction;
import com.huawei.opengauss.jdbc.core.CallableQueryKey;
import com.huawei.opengauss.jdbc.core.Encoding;
import com.huawei.opengauss.jdbc.core.PGStream;
import com.huawei.opengauss.jdbc.core.Query;
import com.huawei.opengauss.jdbc.core.QueryExecutor;
import com.huawei.opengauss.jdbc.core.QueryWithReturningColumnsKey;
import com.huawei.opengauss.jdbc.core.TransactionState;
import com.huawei.opengauss.jdbc.core.Utils;
import com.huawei.opengauss.jdbc.jdbc.AutoSave;
import com.huawei.opengauss.jdbc.jdbc.PreferQueryMode;
import com.huawei.opengauss.jdbc.log.Log;
import com.huawei.opengauss.jdbc.log.Logger;
import com.huawei.opengauss.jdbc.util.HostSpec;
import com.huawei.opengauss.jdbc.util.LruCache;
import com.huawei.opengauss.jdbc.util.PSQLException;
import com.huawei.opengauss.jdbc.util.PSQLState;
import com.huawei.opengauss.jdbc.util.V1CompatibilityUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Properties;

public abstract class QueryExecutorBase
implements QueryExecutor {
    private static Log LOGGER = Logger.getLogger(QueryExecutorBase.class.getName());
    private static final int V1_PROTOCOL_VERSION = 1;
    protected final PGStream pgStream;
    private final String user;
    private final String database;
    private final int cancelSignalTimeout;
    private int cancelPid;
    private int cancelKey;
    private boolean closed = false;
    private String serverVersion;
    private int serverVersionNum = 0;
    private TransactionState transactionState;
    private final boolean reWriteBatchedInserts;
    private final boolean columnSanitiserDisabled;
    private final PreferQueryMode preferQueryMode;
    private AutoSave autoSave;
    private boolean flushCacheOnDeallocate = true;
    private Properties props;
    private boolean standardConformingStrings = false;
    private boolean valid = true;
    private SQLWarning warnings;
    private final ArrayList<PGNotification> notifications = new ArrayList();
    private final LruCache<Object, CachedQuery> statementCache;
    private final CachedQueryCreateAction cachedQueryCreateAction;
    private int rsaPubKeyLen = -1;
    private int ecdhKeyLen = -1;
    private byte[] rsaPubKey;
    private byte[] ecdhKey;

    protected QueryExecutorBase(PGStream pgStream, String user, String database, int cancelSignalTimeout, Properties info) throws SQLException {
        this.pgStream = pgStream;
        this.user = user;
        this.database = database;
        this.cancelSignalTimeout = cancelSignalTimeout;
        this.reWriteBatchedInserts = PGProperty.REWRITE_BATCHED_INSERTS.getBoolean(info);
        this.columnSanitiserDisabled = PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(info);
        String preferMode = PGProperty.PREFER_QUERY_MODE.get(info);
        this.preferQueryMode = PreferQueryMode.of(preferMode);
        this.autoSave = AutoSave.of(PGProperty.AUTOSAVE.get(info));
        this.cachedQueryCreateAction = new CachedQueryCreateAction(this);
        this.props = info;
        this.statementCache = new LruCache<Object, CachedQuery>(Math.max(0, PGProperty.PREPARED_STATEMENT_CACHE_QUERIES.getInt(info)), Math.max(0, PGProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getInt(info) * 1024 * 1024), false, this.cachedQueryCreateAction, new LruCache.EvictAction<CachedQuery>(){

            @Override
            public void evict(CachedQuery cachedQuery) throws SQLException {
                cachedQuery.query.close();
                if (!cachedQuery.isRewriteQueriesEmpty()) {
                    for (Query query : cachedQuery.getRewriteQueries()) {
                        query.close();
                    }
                    cachedQuery.clearRewriteQueries();
                }
            }
        });
    }

    protected abstract void sendCloseMessage() throws IOException;

    @Override
    public void setNetworkTimeout(int milliseconds) throws IOException {
        this.pgStream.setNetworkTimeout(milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws IOException {
        return this.pgStream.getNetworkTimeout();
    }

    @Override
    public HostSpec getHostSpec() {
        return this.pgStream.getHostSpec();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    public void setBackendKeyData(int cancelPid, int cancelKey) {
        this.cancelPid = cancelPid;
        this.cancelKey = cancelKey;
    }

    @Override
    public int getBackendPID() {
        return this.cancelPid;
    }

    @Override
    public void abort() {
        block2: {
            try {
                this.pgStream.getSocket().close();
            }
            catch (IOException e) {
                if (!LOGGER.isTraceEnabled()) break block2;
                LOGGER.trace("Catch IOException on close:", e);
            }
        }
        this.closed = true;
    }

    @Override
    public void close() {
        block4: {
            if (this.closed) {
                return;
            }
            try {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(" FE=> Terminate");
                }
                this.sendCloseMessage();
                this.pgStream.flush();
                this.pgStream.close();
                GlobalConnectionTracker.releaseConnectionReference(this, this.props);
            }
            catch (IOException ioe) {
                if (!LOGGER.isTraceEnabled()) break block4;
                LOGGER.trace("Discarding IOException on close:", ioe);
            }
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return !this.valid || this.closed;
    }

    @Override
    public void setAvailability(boolean availability) {
        this.valid = availability;
    }

    @Override
    public void sendQueryCancel() throws SQLException {
        if (this.cancelPid <= 0) {
            return;
        }
        PGStream cancelStream = null;
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(" FE=> CancelRequest(pid=" + this.cancelPid + ",ckey=" + this.cancelKey + ")");
            }
            cancelStream = new PGStream(this.pgStream.getSocketFactory(), this.pgStream.getHostSpec(), this.cancelSignalTimeout);
            if (this.cancelSignalTimeout > 0) {
                cancelStream.getSocket().setSoTimeout(this.cancelSignalTimeout);
            }
            cancelStream.sendInteger4(16);
            cancelStream.sendInteger2(1234);
            cancelStream.sendInteger2(5678);
            cancelStream.sendInteger4(this.cancelPid);
            cancelStream.sendInteger4(this.cancelKey);
            cancelStream.flush();
            cancelStream.receiveEOF();
        }
        catch (IOException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Ignoring exception on cancel request:", e);
            }
            throw new SQLException("Cancel request on this connection failed");
        }
        finally {
            block15: {
                if (cancelStream != null) {
                    try {
                        cancelStream.close();
                    }
                    catch (IOException e) {
                        if (!LOGGER.isTraceEnabled()) break block15;
                        LOGGER.trace("Catch IOException on close:", e);
                    }
                }
            }
        }
    }

    public synchronized void addWarning(SQLWarning newWarning) {
        if (this.warnings == null) {
            this.warnings = newWarning;
        } else {
            this.warnings.setNextWarning(newWarning);
        }
    }

    public synchronized void addNotification(PGNotification notification) {
        this.notifications.add(notification);
    }

    @Override
    public synchronized PGNotification[] getNotifications() throws SQLException {
        PGNotification[] array = this.notifications.toArray(new PGNotification[this.notifications.size()]);
        this.notifications.clear();
        return array;
    }

    @Override
    public synchronized SQLWarning getWarnings() {
        SQLWarning chain = this.warnings;
        this.warnings = null;
        return chain;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public int getServerVersionNum() {
        if (this.serverVersionNum != 0) {
            return this.serverVersionNum;
        }
        this.serverVersionNum = Utils.parseServerVersionStr(this.serverVersion);
        return this.serverVersionNum;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public void setServerVersionNum(int serverVersionNum) {
        this.serverVersionNum = serverVersionNum;
    }

    public synchronized void setTransactionState(TransactionState state) {
        this.transactionState = state;
    }

    public synchronized void setStandardConformingStrings(boolean value) {
        this.standardConformingStrings = value;
    }

    @Override
    public synchronized boolean getStandardConformingStrings() {
        return this.standardConformingStrings;
    }

    @Override
    public synchronized TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setEncoding(Encoding encoding) throws IOException {
        this.pgStream.setEncoding(encoding);
    }

    @Override
    public Encoding getEncoding() {
        return this.pgStream.getEncoding();
    }

    @Override
    public boolean isReWriteBatchedInsertsEnabled() {
        return this.reWriteBatchedInserts;
    }

    @Override
    public final CachedQuery borrowQuery(String sql) throws SQLException {
        return this.statementCache.borrow(sql);
    }

    @Override
    public final CachedQuery borrowCallableQuery(String sql) throws SQLException {
        return this.statementCache.borrow(new CallableQueryKey(sql));
    }

    @Override
    public final CachedQuery borrowReturningQuery(String sql, String[] columnNames) throws SQLException {
        return this.statementCache.borrow(new QueryWithReturningColumnsKey(sql, true, true, columnNames));
    }

    @Override
    public CachedQuery borrowQueryByKey(Object key) throws SQLException {
        return this.statementCache.borrow(key);
    }

    @Override
    public void releaseQuery(CachedQuery cachedQuery) {
        this.statementCache.put(cachedQuery.key, cachedQuery);
    }

    @Override
    public final Object createQueryKey(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) {
        Object key = columnNames == null || columnNames.length != 0 ? new QueryWithReturningColumnsKey(sql, isParameterized, escapeProcessing, columnNames) : (isParameterized ? sql : new BaseQueryKey(sql, false, escapeProcessing));
        return key;
    }

    @Override
    public CachedQuery createQueryByKey(Object key) throws SQLException {
        return this.cachedQueryCreateAction.create(key);
    }

    @Override
    public final CachedQuery createQuery(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) throws SQLException {
        Object key = this.createQueryKey(sql, escapeProcessing, isParameterized, columnNames);
        return this.createQueryByKey(key);
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return this.columnSanitiserDisabled;
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return this.preferQueryMode;
    }

    @Override
    public AutoSave getAutoSave() {
        return this.autoSave;
    }

    @Override
    public void setAutoSave(AutoSave autoSave) {
        this.autoSave = autoSave;
    }

    protected boolean willHealViaReparse(SQLException e) {
        if (PSQLState.INVALID_SQL_STATEMENT_NAME.getState().equals(e.getSQLState())) {
            return true;
        }
        if (PSQLState.INVALID_CACHE_PLAN.getState().equals(e.getSQLState())) {
            return true;
        }
        if (!PSQLState.NOT_IMPLEMENTED.getState().equals(e.getSQLState())) {
            return false;
        }
        if (!(e instanceof PSQLException)) {
            return false;
        }
        PSQLException pe = (PSQLException)e;
        return this.getProtocolVersion() == 1 && V1CompatibilityUtil.willHealViaReparse(pe);
    }

    @Override
    public boolean willHealOnRetry(SQLException e) {
        if (this.autoSave == AutoSave.NEVER && this.getTransactionState() == TransactionState.FAILED) {
            return false;
        }
        return this.willHealViaReparse(e);
    }

    public boolean isFlushCacheOnDeallocate() {
        return this.flushCacheOnDeallocate;
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        this.flushCacheOnDeallocate = flushCacheOnDeallocate;
    }

    protected boolean hasNotifications() {
        return this.notifications.size() > 0;
    }

    public void setRsaPubKey(byte[] rsaPubKey, int len) {
        this.rsaPubKey = rsaPubKey;
        this.rsaPubKeyLen = len;
    }

    public void setEcdhKey(byte[] ecdhKey, int len) {
        this.ecdhKey = ecdhKey;
        this.ecdhKeyLen = len;
    }

    @Override
    public byte[] getRsaPubKey() throws SQLException {
        if (this.rsaPubKey == null) {
            throw new SQLException("Invalid RSA pub key");
        }
        return this.rsaPubKey;
    }

    @Override
    public byte[] getEcdhKey() throws SQLException {
        if (this.ecdhKey == null) {
            throw new SQLException("Invalid ECDH key");
        }
        return this.ecdhKey;
    }

    @Override
    public int getRsaPubKeyLen() throws SQLException {
        if (this.rsaPubKeyLen <= 0) {
            throw new SQLException("Invalid RSA key length");
        }
        return this.rsaPubKeyLen;
    }

    @Override
    public int getEcdhKeyLen() throws SQLException {
        if (this.ecdhKeyLen <= 0) {
            throw new SQLException("Invalid ECDH key length");
        }
        return this.ecdhKeyLen;
    }
}

